public class Verbete{
    private String entrada;
    private String descricao;
    private ClasseGramatical classeGramatical;
    private Verbete[] sinonimos;
    
    public Verbete(String entrada, ClasseGramatical classeGramatical, String descricao){
        this.setEntrada(entrada);
        this.setClasseGramatical(classeGramatical); 
        this.setDescricao(descricao);
        this.sinonimos = new Verbete[0];
    }   
    
    private void setEntrada(String entrada){
        this.entrada = entrada;
    } 
    
    private void setClasseGramatical(ClasseGramatical classeGramatical){
        this.classeGramatical = classeGramatical;
    }     
    
    private void setDescricao(String descricao){
        this.descricao = descricao;
    } 
    
     public String getEntrada(){
        return this.entrada;
    } 
    
    public ClasseGramatical getClasseGramatical(){
        return this.classeGramatical;
    }     
    
    public String getDescricao(){
        return this.descricao;
    } 
    
    public boolean isEntrada(String string){
        return this.getEntrada().equals(string);
    } 
    
    public boolean equals(Verbete verbete){
        return this.getEntrada().equals(verbete.getEntrada()) &&
               this.getClasseGramatical().equals(verbete.getClasseGramatical());
    }  
    
    public boolean isEquivalente(Verbete verbete){
        return this.equals(verbete) || this.isSinonimo(verbete);
    }    
    
    public boolean isSinonimo(Verbete verbete){
        for(Verbete sinonimo : this.sinonimos)
          if(verbete.equals(sinonimo))
            return true;
        return false;    
    }    
    
    public void adicionarSinonimo(Verbete verbete){
        if(! this.isSinonimo(verbete)){
            this.addSinonimo(verbete);
            verbete.adicionarSinonimo(this);
        }    
    }    
    
    
    private void addSinonimo(Verbete verbete){
        Verbete[] novo = new Verbete[this.sinonimos.length + 1];
        for(int i = 0; i < this.sinonimos.length; i++)
          novo[i] = this.sinonimos[i];
        novo[novo.length - 1] = verbete;
        this.sinonimos = novo;
    }    
    
    public boolean isPalavra(){
        return this.getClasseGramatical() == ClasseGramatical.SUBSTANTIVO ||
               this.getClasseGramatical() == ClasseGramatical.ADJETIVO ||
               this.getClasseGramatical() == ClasseGramatical.PRONOME;
    }    
    
    public String toString(){
        String rep = this.getEntrada() + "\n";
        rep += this.getClasseGramatical() + ".\n";
        rep += this.getDescricao() + ".\n";
        rep += "sinonimos: ";
        for(Verbete verbete : this.sinonimos)
          rep += verbete.getEntrada() + " - ";
        return rep;  
    }    
    
}

