public class Coluna{
    private String  nome;
    private TipoColuna  tipo;
    private boolean nulo;
    private boolean chavePrimaria;

    
    public Coluna(Coluna coluna){
        this(coluna.getNome(), coluna.getTipo(), !coluna.isNotNull(), coluna.isChavePrimaria());       
    }     
    
    
    public Coluna(String nome, TipoColuna tipo){
        this(nome, tipo, true, false);       
    }     
    
    public Coluna(String nome, TipoColuna tipo, boolean nulo, boolean chavePrimaria){
        this.setNome(nome);
        this.setTipo(tipo);
        this.setNulo(nulo);
        this.setChavePrimaria(chavePrimaria);            
    }    
    
    private void setNome(String nome){
        this.nome = nome;
    }    
    
    private void setTipo(TipoColuna valor){
        this.tipo = valor;
    }     
    
    public void setNulo(boolean nulo){
        this.nulo = nulo;
    } 
    
    public void setChavePrimaria(boolean chavePrimaria){
        this.chavePrimaria = chavePrimaria;
    }    
    
    public String getNome(){
        return this.nome;
    }
    
    public TipoColuna getTipo(){
        return this.tipo;
    }  
    
    public boolean isNotNull(){
        return !this.nulo;
    }   
    
    public boolean isChavePrimaria(){
        return this.chavePrimaria;
    }    
        
    
    
    public boolean equals(Coluna coluna){
        return this.getNome().equals(coluna.getNome()) &&
               this.getTipo().equals(coluna.getTipo());
    }    
    
    public String toString(){
        return this.getNome() + " " + 
               this.getTipo().toString().toLowerCase() + " " + 
               (this.isNotNull() ? "not null" : "null");
    }   
    
    
}

