package br.edu.ifba.inf008.lock;

import java.util.HashSet;
import java.util.Set;

public class ControladorLock{
    private Set<ElementoBD> elementos;
    
    
    public ControladorLock(){
    	this.elementos = new HashSet<ElementoBD>();
    }
    
    public void add(ElementoBD elemento){
    	this.elementos.add(elemento);
    }
    
    public boolean executar(LinhaExecucao linha){
        for(Acao acao : linha.getAcoes()){
            ElementoBD elemento = this.getById(acao.getObjectId());
            if(elemento.podeLock(acao.getLock()))
              elemento.fazerLock(acao.getLock());
            else
              return false;
        }    
        return true;
    } 
    
    public ElementoBD getById(String id){
        for(ElementoBD elemento : this.elementos)
          if(elemento.getObjectId().equals(id))
            return elemento;
        return null;    
    }    
    
}
