package br.edu.ifba.inf008.lock;

import java.util.HashSet;
import java.util.Set;

public class Tabela extends ElementoBD{
    
    
    private Set<Coluna> colunas;
    
    
    public Tabela(String objectId, String nome) {
		super(objectId, nome);
		this.colunas = new HashSet<Coluna>();
	}
    

    public void add(Coluna coluna){
    	this.colunas.add(coluna);
    }    
    
    public boolean podeBloquearLeitura(){
        for(Coluna coluna : this.colunas)
          if(!coluna.podeBloquearLeitura())
          return false;
        return true;  
    };    
    
    public boolean podeBloquearEscrita(){
        for(Coluna coluna : this.colunas)
          if(!(coluna.getLock() == TipoLock.LIVRE))
          return false;
        return true;  
        
   };       

    public void liberarLock(){
        for(Coluna coluna : this.colunas)
          coluna.liberarLock();
    };
    
    public  void bloquearLeitura(){
        for(Coluna coluna : this.colunas)
          coluna.bloquearLeitura();
    };
    
    public  void bloquearEscrita(){
        for(Coluna coluna : this.colunas)
          coluna.bloquearEscrita();
    };

}
