package br.edu.ifba.inf008.mediaCenter.model;

public abstract class Servidor{
    public String id;
    
    public Servidor(String id){
        this.id = id;
    }   
    
    public String getId(){
        return this.id;
    }    
    
    public boolean temCapacidade(long tamanho){
        return this.getCapacidade() >= tamanho;
    }    
    
    public abstract double getLatenciaEscrita();
    
    public abstract double getLatenciaLeitura();    
    
    public double gravar(long tamanho){
      this.ocupar(tamanho);
      return tamanho * this.getLatenciaEscrita();
    };
    
    public abstract void ocupar(long tamanho); 
    
    public abstract long getCapacidade();
    
    public String toString(){
        return "Servidor [" + this.id + 
                         " / R: " + this.getLatenciaLeitura() +  
                         " / W: " + this.getLatenciaEscrita() + "]" +
                         " / Size: " + getCapacidade();
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Servidor other = (Servidor) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}    
    
    
    
    
}
