package br.edu.ifba.inf008.mediaCenter.model;

import java.util.HashSet;
import java.util.Set;

public class ServidorReplicado extends Servidor{
    
    private Set<Servidor> servidores;
    
    public ServidorReplicado(String id){
        super(id);
        this.servidores = new HashSet<Servidor>();
    }    
    
    public long getCapacidade(){
        long capacidade = Long.MAX_VALUE;
        for(Servidor s : this.servidores)
          if(capacidade > s.getCapacidade())
            capacidade = s.getCapacidade();
        return capacidade;
    } 
    
    public double getLatenciaEscrita(){
        double latencia = Double.NaN;
        for(Servidor s : this.servidores)
          if(Double.isNaN(latencia)|| latencia < s.getLatenciaEscrita())
            latencia = s.getLatenciaEscrita();
        return latencia;
    }  
    
    public double getLatenciaLeitura(){
        double latencia = Double.NaN;
        for(Servidor s : this.servidores)
          if(Double.isNaN(latencia)|| latencia > s.getLatenciaLeitura())
            latencia = s.getLatenciaLeitura();
        return latencia;
    }     
    
     public void ocupar(long tamanho){
        for(Servidor s : this.servidores)
          s.ocupar(tamanho);
     };    
     
    public void addServidor(Servidor servidor){
        this.servidores.add(servidor);
    }   
    
    public String toString(){
        String str = super.toString() + "\n";
        for(Servidor s : this.servidores)
           str = str + "\t\t" + s + "@" + this.id + "\n";
        return str;   
        
    }

	public Set<Servidor> getServidores() {
		return servidores;
	}  
    
    
    
    
}