package br.edu.ifba.inf008.mediaCenter.model;
public class ServidorBasico extends Servidor{
    private double latenciaLeitura;
    private double latenciaEscrita;    
    private long capacidadeOcupada;
    private long capacidadeTotal;
    
   
    public ServidorBasico(String id, long capacidadeTotal, double latenciaLeitura,
                          double latenciaEscrita){
      super(id);
      this.capacidadeOcupada = 0;
      this.capacidadeTotal = capacidadeTotal;
      this.latenciaLeitura = latenciaLeitura;
      this.latenciaEscrita = latenciaEscrita;
    }    
    
    public long getCapacidade(){
        return this.capacidadeTotal - this.capacidadeOcupada;
    }  
    
    public double getLatenciaEscrita(){
        return this.latenciaEscrita;
    } 
    
    public double getLatenciaLeitura(){
        return this.latenciaLeitura;
    } 
    
    
     public void ocupar(long tamanho){
         this.capacidadeOcupada += tamanho;
     }

	public long getCapacidadeOcupada() {
		return capacidadeOcupada;
	}

	public void setCapacidadeOcupada(long capacidadeOcupada) {
		this.capacidadeOcupada = capacidadeOcupada;
	}

	public long getCapacidadeTotal() {
		return capacidadeTotal;
	}

	public void setCapacidadeTotal(long capacidadeTotal) {
		this.capacidadeTotal = capacidadeTotal;
	}

	public void setLatenciaLeitura(double latenciaLeitura) {
		this.latenciaLeitura = latenciaLeitura;
	}

	public void setLatenciaEscrita(double latenciaEscrita) {
		this.latenciaEscrita = latenciaEscrita;
	}; 
     
     
    
}
