public abstract class Mapa{
    
    private String id;
    
    public Mapa(String id){
        this.id = id;
    }    
    
    protected abstract Pixel[][] getPixels();
    protected abstract Pixel getPixel(int x, int y); 
    protected abstract void setPixel(int x, int y, Pixel pixel);     
    
    public int getAltura(){
        return this.getPixels().length;
    }    
    
    public int getLargura(){
        return this.getPixels()[0].length;
    }    
    
    public double getSimilaridade(Fragmento fragmento){
        double similaridade = Double.MAX_VALUE;
        for(int x = 0; x <= this.getAltura() - fragmento.getAltura(); x++)
          for(int y = 0; y <= this.getLargura() - fragmento.getLargura(); y++){
              double simTrecho = this.getSimilaridade(fragmento, x, y);
              if(simTrecho < similaridade)
                similaridade = simTrecho;  
          }      
        return similaridade;
    }    
    
//    cálculo da média da similaridade dos pixels
    public double getSimilaridade(Fragmento fragmento, int x, int y){
        int xMap, xFrag;
        int yMap, yFrag;
        double similaridade = 0;
        
        for(xMap = x, xFrag = 0; xFrag < fragmento.getAltura(); xMap++, xFrag++)
          for(yMap = y, yFrag = 0; yFrag < fragmento.getLargura(); yMap++, yFrag++)
            similaridade += fragmento.getPixel(xFrag, yFrag).getSimilaridade(this.getPixel(xMap, yMap));
        return similaridade / (fragmento.getAltura() * fragmento.getLargura());                             
    }    
    
    public String toString(){
        return this.id;
    }    
}