public class CorRGB{
    
    public static final int RED = 0; 
    public static final int GREEN = 1;    
    public static final int BLUE = 2;   
    
    public static final CorRGB COR_PRETO = new CorRGB((short)0, (short)0, (short)0);    
    public static final CorRGB COR_BRANCA = new CorRGB((short)255, (short)255, (short)255);
    public static final CorRGB COR_VERMELHA = new CorRGB((short)255, (short)0, (short)0);    
    public static final CorRGB COR_VERDE = new CorRGB((short)0, (short)255, (short)0);    
    
    private static final float[] luminosidadeIndice = {0.3F, 0.59F, 0.11F};
    
    private short[] cromas;
    

    public CorRGB(short red, short green, short blue){
        this.cromas = new short[3];
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);        
    }    
        
    private void setRed(short red){
        this.setCroma(CorRGB.RED, red);      
    }   
    
    private void setGreen(short green){
        this.setCroma(CorRGB.GREEN, green);
    }  
    
    private void setBlue(short blue){
        this.setCroma(CorRGB.BLUE, blue);
    }  
    
    public short getRed(){
        return this.cromas[CorRGB.RED];
    }    
    
    public short getGreen(){
        return this.cromas[CorRGB.GREEN];
    } 
    
    public short getBlue(){
        return this.cromas[CorRGB.BLUE];
    }     
    
    private void setCroma(int croma, short valor){
        if(valor >= 0 && valor <= 255)        
            this.cromas[croma] = valor; 
    } 
    
    private short getCroma(int i){
         return this.cromas[i]; 
    }     
    
    public int getLuminosidade(){
        float luminosidade = 0;
        for(int i = 0 ; i < this.cromas.length; i++)
            luminosidade += this.cromas[i] * CorRGB.luminosidadeIndice[i];
        return (int) luminosidade;   
    } 
    
    public boolean equals(CorRGB cor){
        for(int i = 0 ; i < this.cromas.length; i++)
            if(this.getCroma(i) != cor.getCroma(i))
              return false;
        return true;      
    }
    
    public String toString(){
        String rep = "#";
        for(short valor : this.cromas)
          rep += this.numToHexa2((byte)(valor / 16)) + this.numToHexa2((byte)(valor % 16));
        return rep;  
    } 
    
    
    private String numToHexa2(byte num){
        if(num >= 0 && num <= 9)
          return "" + ((char)(('0' + num)));
        else  
          return "" + ((char)('A' + (num - 10)));
    }        
    
    private String numToHexa(byte num){
        switch(num){
            case 10 : return "A";
            case 11 : return "B";            
            case 12 : return "C";
            case 13 : return "D";            
            case 14 : return "E";
            case 15 : return "F";            
            default : return "" + num;
        }    
    }    
    
}
