package br.edu.inf008.contabil.exceptions;

public class SaldoInsuficienteException extends Exception{
	
	private String nomeConta;
	private double saldoDisponivel;
	private double saldoNecessario;
	
	
	public SaldoInsuficienteException(Exception exception, String nomeConta, double saldoDisponivel, double saldoNecessario){
		super(exception);
		this.init(nomeConta, saldoDisponivel, saldoNecessario);
	}
	
	public SaldoInsuficienteException(String nomeConta, double saldoDisponivel, double saldoNecessario){
		this.init(nomeConta, saldoDisponivel, saldoNecessario);
	}

	private void init(String nomeConta, double saldoDisponivel, double saldoNecessario){
		this.nomeConta = nomeConta;
		this.saldoDisponivel = saldoDisponivel;
		this.saldoNecessario = saldoNecessario;		
	}
	
	public String getNomeConta() {
		return this.nomeConta;
	}

	public double getSaldoDisponivel() {
		return this.saldoDisponivel;
	}

	public double getSaldoNecessario() {
		return this.saldoNecessario;
	}	
	
	

}
