package br.edu.ifba.inf008.contabil.model;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

import br.edu.ifba.inf008.contabil.util.ComparadorContaPeloSaldo;
import br.edu.ifba.inf008.contabil.util.Ordenador;
import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;
import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public class BalancoContabil{
    private Set<Conta> contas;
    
    public BalancoContabil(){
        this.contas = new TreeSet<Conta>();
    }    
    
    public void adicionar(Conta conta){
    	this.contas.add(conta);
    } 
    
    public Conta buscarPeloNome(String nome) throws ContaNaoExistenteException{
        for(Conta conta : this.contas)
          if(conta.getNome().equals(nome))
            return conta;
        throw new ContaNaoExistenteException(nome);    
    }
    
    public void ajustar(String nomeContaCredito, 
                        String nomeContaDebito, 
                        double valor) throws ContaNaoExistenteException, 
    										 SaldoInsuficienteException{
      this.buscarPeloNome(nomeContaCredito).creditar(valor);
      this.buscarPeloNome(nomeContaDebito).debitar(valor);
    }
    
    public String toString(){
//        Ordenador ordenador = new Ordenador();
        String rep = "";
//        Collections.sort(this.contas, new ComparadorContaPeloSaldo());
        for(Conta conta : this.contas)
            rep += conta + "\n";
        return rep;    
    }    
    
}
