package br.edu.ifba.inf008.contabil.dao.mem;

import java.util.HashMap;
import java.util.Map;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.model.Conta;
import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;

public class ContaDAOMemory implements ContaDAOIF {

	private Map<String, Conta> contas;
	
	public ContaDAOMemory(){
		this.contas = new HashMap<String, Conta>();
	}
	
	@Override
	public Conta buscarPeloNome(String nomeContaCredito) throws ContaNaoExistenteException {
		for(Conta c : this.contas.values())
			if(c.getNome().equals(nomeContaCredito))
				return c;
		throw new ContaNaoExistenteException(nomeContaCredito); 
	}

	@Override
	public void salvar(Conta conta) throws Exception {
		this.contas.put(conta.getId(), conta);
	}

	@Override
	public void criar(Conta conta) throws Exception {
		this.contas.put(conta.getId(), conta);
	}

}
