package br.edu.ifba.inf008.contabil.dao.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.dao.LancamentoDAOIF;
import br.edu.ifba.inf008.contabil.model.Conta;
import br.edu.ifba.inf008.contabil.model.Lancamento;

public class LancamentoDAOSQL extends AbstractDAOSQL  implements LancamentoDAOIF {

	private static final String INSERT = 
			"INSERT INTO lancamento(instante, descricao, id_conta_debito, id_conta_credito, valor) " +
			"VALUES(?, ?, ?, ?, ?)";
	
	private static final String SELECT_ALL = 
			"SELECT instante, descricao, id_conta_debito, id_conta_credito, valor " +
		    "FROM lancamento"; 
	
	private ContaDAOIF contaDAO;
	
	public LancamentoDAOSQL(ContaDAOIF contaDAO){
		this.contaDAO = contaDAO;
	}
	
	@Override
	public void criar(Lancamento lancamento) throws Exception {
		PreparedStatement stmt = this.getConnection().prepareStatement(LancamentoDAOSQL.INSERT);
		stmt.setLong(1, lancamento.getTimestamp());
		stmt.setString(2, lancamento.getDescricao());
		stmt.setString(3, lancamento.getDebito().getId());
		stmt.setString(4, lancamento.getCredito().getId());
		stmt.setDouble(5, lancamento.getValor());
		stmt.executeUpdate();
	}

	@Override
	public Collection<Lancamento> buscarTodos() throws Exception {
		Collection <Lancamento> lancamentos = new ArrayList<Lancamento>();
		PreparedStatement stmt = this.getConnection().prepareStatement(SELECT_ALL);
		ResultSet rSet = stmt.executeQuery();
		while(rSet.next()){
			long ts = rSet.getLong("instante");
			String descricao = rSet.getString("descricao");
			double valor = rSet.getDouble("valor");
			Conta debito = this.contaDAO.buscarPeloId(rSet.getString("id_conta_debito"));
			Conta credito = this.contaDAO.buscarPeloId(rSet.getString("id_conta_debito"));
			Lancamento lancamento = new Lancamento(ts, descricao, credito, debito, valor);
			lancamentos.add(lancamento);
		}
		
		return lancamentos;
	}

}
