package inf008;

import inf008.contabil.*;
import inf008.contabil.entidades.PatrimonioLiquido;
import inf008.exception.ContaNaoEncontradaException;
import inf008.persistencia.ContaDAO;
import inf008.persistencia.LancamentoDAO;
import inf008.ui.ContaUI;

public class App{
	
	public void run(String fileName) throws Exception{
		Factory factory = new Factory(fileName);
		ContaDAO contaDAO = factory.getContaDAO();
		LancamentoDAO lancamentoDAO = factory.getLancamentoDAO();
		ContabilSessao contabilSessao = factory.getContabilSessao();
		ContaUI contaUI = factory.getUI();
		
		contabilSessao.setContaDAO(contaDAO);
		contabilSessao.setLancamentoDAO(lancamentoDAO);
		contaUI.setContabilSessao(contabilSessao);
		
		contaUI.exibir();
		
		
	}
	
    public static void main(String[] args){
      App app = new App();
      try{
    	  app.run(args[0]);
      }catch(Exception e){
    	  e.printStackTrace();
      }
    }   
    
}
