package inf008.contabil;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import inf008.contabil.entidades.Ativo;
import inf008.contabil.entidades.Conta;
import inf008.contabil.entidades.Lancamento;
import inf008.contabil.entidades.Passivo;
import inf008.contabil.entidades.PatrimonioLiquido;
import inf008.exception.ContaNaoEncontradaException;
import inf008.persistencia.ContaDAO;
import inf008.persistencia.LancamentoDAO;
import inf008.persistencia.memory.ContaDAOMemory;
import inf008.persistencia.memory.LancamentoDAOMemory;
import inf008.persistencia.sql.ContaDAOSQL;
import inf008.persistencia.sql.LancamentoDAOSQL;
import inf008.ui.vo.ContaVO;
import inf008.ui.vo.LancamentoVO;

public class RegistroContabil implements ContabilSessao{


	private ContaDAO contaDAO;
    private LancamentoDAO lancamentoDAO;    
    

    public RegistroContabil(){
    }
    
    public void setContaDAO(ContaDAO contaDAO) {
		this.contaDAO = contaDAO;
	}

	public void setLancamentoDAO(LancamentoDAO lancamentoDAO) {
		this.lancamentoDAO = lancamentoDAO;
	}    
    
    public List<LancamentoVO> gerarLivro() throws Exception{
    	List<Lancamento> lancamentos = new ArrayList<Lancamento>();
    	List<LancamentoVO> lancamentosVO = new ArrayList<LancamentoVO>();
    	lancamentos.addAll(this.lancamentoDAO.findAll());
        Collections.sort(lancamentos);

        for(Lancamento lancamento : lancamentos)
        	lancamentosVO.add(new LancamentoVO(lancamento.getOrdem(),
        									   lancamento.getDescricao(),
        									   lancamento.getValor(),
        									   lancamento.getCredito().getNome(),
        									   lancamento.getDebito().getNome()));
        return lancamentosVO;  
     }     
    
    
    public void registrarFatoContabil(int id, String descricao,
                                      String nomeContaCredito,
                                      String nomeContaDebito,
                                      double valor) throws Exception{
                                          
                                          
      Conta credito = this.contaDAO.findByName(nomeContaCredito);                                      
      Conta debito = this.contaDAO.findByName(nomeContaDebito);
      Lancamento lancamento = new Lancamento(id, descricao, credito, debito, valor);
      this.lancamentoDAO.save(lancamento);
      credito.creditar(valor);
      debito.debitar(valor);
      this.contaDAO.update(credito);
      this.contaDAO.update(debito);
    } 
    
    public void addConta(char tipoConta, int id, String nome) throws Exception{
    	Conta conta = null;
		if(tipoConta == 'A')
			conta = new Ativo(id, nome);
		else if(tipoConta == 'P')
			conta = new Passivo(id, nome);
		else if(tipoConta == 'L')
			conta = new PatrimonioLiquido(id, nome);
        this.contaDAO.save(conta);
    } 
    
    public List<ContaVO> gerarBalanco() throws Exception{
    	List<Conta> contas = new ArrayList<Conta>();
    	List<ContaVO> contasVO = new ArrayList<ContaVO>();    	
    	contas.addAll(this.contaDAO.findAll());
        Collections.sort(contas);
        for(Conta conta : contas)
        	contasVO.add(new ContaVO(conta.getTipo().charAt(0),
        							 conta.getId(),
        							 conta.getNome(),
        							 conta.getSaldo()));
        return contasVO;  
     }
    
}
