package inf008.ui.jfc;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

import java.awt.GridBagConstraints;
import javax.swing.JTextField;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;

import inf008.contabil.ContabilSessao;
import inf008.contabil.RegistroContabil;
import inf008.ui.ContaUI;
import inf008.ui.vo.ContaVO;

import javax.swing.JTextArea;
import javax.swing.UIManager;
import java.awt.Color;

public class JFatoContabil extends JFrame implements ActionListener, ContaUI{

	private ContabilSessao logica;
	
	private LancamentoModel modelo;	
	
	
	private JPanel contentPane;
	private JTextField txtDescricao;
	private JTextField txtValor;
	private JTextField txtOrdem;
	private JComboBox cbCredito;
	private JComboBox cbDebito;	
	
	
	private JTable table;
	

//	public void exibir(){
//		EventQueue.invokeLater(new Runnable() {
//			public void run() {
//				try {
//					JFatoContabil frame = new JFatoContabil();
//					this.asm
//					frame.setVisible(true);
//				} catch (Exception e) {
//					e.printStackTrace();
//				}
//			}
//		});
//	}
	

	public void exibir(){
		this.asm();
		this.setVisible(true);
	}
	
	
	public void asm(){
		String[] contasNome = null;
		try {
			contasNome = this.getNomeContas().toArray(new String[0]);
		} catch (Exception e) {
			contasNome = new String[0];
		}		
		
		
		setTitle("Registro de Fato Contabil");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 475, 418);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		GridBagLayout gbl_contentPane = new GridBagLayout();
		gbl_contentPane.columnWidths = new int[] {30, 100, 260, 0};
		gbl_contentPane.rowHeights = new int[] {20, 20, 20, 20, 20, 0, 0, 0};
		gbl_contentPane.columnWeights = new double[]{0.0, 1.0, 1.0, Double.MIN_VALUE};
		gbl_contentPane.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
		contentPane.setLayout(gbl_contentPane);
		
		JLabel lblDescricao = new JLabel("Descri\u00E7\u00E3o do Fato:");
		GridBagConstraints gbc_lblDescricao = new GridBagConstraints();
		gbc_lblDescricao.anchor = GridBagConstraints.EAST;
		gbc_lblDescricao.insets = new Insets(0, 0, 5, 5);
		gbc_lblDescricao.gridx = 1;
		gbc_lblDescricao.gridy = 0;
		contentPane.add(lblDescricao, gbc_lblDescricao);
		
		txtDescricao = new JTextField();
		GridBagConstraints gbc_txtDescricao = new GridBagConstraints();
		gbc_txtDescricao.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtDescricao.insets = new Insets(0, 0, 5, 0);
		gbc_txtDescricao.gridx = 2;
		gbc_txtDescricao.gridy = 0;
		contentPane.add(txtDescricao, gbc_txtDescricao);
		txtDescricao.setColumns(10);
		
		JLabel lblContaCredito = new JLabel("Conta Cr\u00E9dito:");
		GridBagConstraints gbc_lblContaCredito = new GridBagConstraints();
		gbc_lblContaCredito.anchor = GridBagConstraints.EAST;
		gbc_lblContaCredito.insets = new Insets(0, 0, 5, 5);
		gbc_lblContaCredito.gridx = 1;
		gbc_lblContaCredito.gridy = 1;
		contentPane.add(lblContaCredito, gbc_lblContaCredito);
		
		cbCredito = new JComboBox(contasNome);
		GridBagConstraints gbc_cbCredito = new GridBagConstraints();
		gbc_cbCredito.fill = GridBagConstraints.HORIZONTAL;
		gbc_cbCredito.insets = new Insets(0, 0, 5, 0);
		gbc_cbCredito.gridx = 2;
		gbc_cbCredito.gridy = 1;
		contentPane.add(cbCredito, gbc_cbCredito);
		
		JLabel lblDebito = new JLabel("Conta D\u00E9bito:");
		GridBagConstraints gbc_lblDebito = new GridBagConstraints();
		gbc_lblDebito.anchor = GridBagConstraints.EAST;
		gbc_lblDebito.insets = new Insets(0, 0, 5, 5);
		gbc_lblDebito.gridx = 1;
		gbc_lblDebito.gridy = 2;
		contentPane.add(lblDebito, gbc_lblDebito);
		
		
		cbDebito = new JComboBox(contasNome);
		GridBagConstraints gbc_cbDebito = new GridBagConstraints();
		gbc_cbDebito.fill = GridBagConstraints.HORIZONTAL;
		gbc_cbDebito.insets = new Insets(0, 0, 5, 0);
		gbc_cbDebito.gridx = 2;
		gbc_cbDebito.gridy = 2;
		contentPane.add(cbDebito, gbc_cbDebito);
		
		JLabel lblValor = new JLabel("Valor:");
		GridBagConstraints gbc_lblValor = new GridBagConstraints();
		gbc_lblValor.anchor = GridBagConstraints.EAST;
		gbc_lblValor.insets = new Insets(0, 0, 5, 5);
		gbc_lblValor.gridx = 1;
		gbc_lblValor.gridy = 3;
		contentPane.add(lblValor, gbc_lblValor);
		
		txtValor = new JTextField();
		GridBagConstraints gbc_txtValor = new GridBagConstraints();
		gbc_txtValor.insets = new Insets(0, 0, 5, 0);
		gbc_txtValor.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtValor.gridx = 2;
		gbc_txtValor.gridy = 3;
		contentPane.add(txtValor, gbc_txtValor);
		txtValor.setColumns(10);
		
		JLabel lblOrdem = new JLabel("N\u00FAmero de Ordem:");
		GridBagConstraints gbc_lblOrdem = new GridBagConstraints();
		gbc_lblOrdem.anchor = GridBagConstraints.EAST;
		gbc_lblOrdem.insets = new Insets(0, 0, 5, 5);
		gbc_lblOrdem.gridx = 1;
		gbc_lblOrdem.gridy = 4;
		contentPane.add(lblOrdem, gbc_lblOrdem);
		
		txtOrdem = new JTextField();
		GridBagConstraints gbc_txtOrdem = new GridBagConstraints();
		gbc_txtOrdem.insets = new Insets(0, 0, 5, 0);
		gbc_txtOrdem.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtOrdem.gridx = 2;
		gbc_txtOrdem.gridy = 4;
		contentPane.add(txtOrdem, gbc_txtOrdem);
		txtOrdem.setColumns(10);
		
		JButton btnRegistrar = new JButton("Registrar");
		GridBagConstraints gbc_btnRegistrar = new GridBagConstraints();
		gbc_btnRegistrar.insets = new Insets(0, 0, 5, 0);
		gbc_btnRegistrar.gridx = 2;
		gbc_btnRegistrar.gridy = 5;
		btnRegistrar.addActionListener(this);
		contentPane.add(btnRegistrar, gbc_btnRegistrar);
		
		JPanel panel = new JPanel();
		panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Livro", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
		GridBagConstraints gbc_panel = new GridBagConstraints();
		gbc_panel.fill = GridBagConstraints.BOTH;
		gbc_panel.gridwidth = 3;
		gbc_panel.gridx = 0;
		gbc_panel.gridy = 6;
		contentPane.add(panel, gbc_panel);
		panel.setLayout(new BorderLayout(0, 0));
		try {
			this.modelo = new LancamentoModel(this.logica);
		} catch (Exception e) {
			this.modelo = null;
		}
		table = new JTable(this.modelo);
		panel.add(table);
	}

	/**
	 * Create the frame.
	 * @throws Exception 
	 */
	public JFatoContabil(){
		
	}
	
	private void reset(){
		this.txtDescricao.setText("");
		this.txtValor.setText("");
		this.txtOrdem.setText("");
		this.cbCredito.setSelectedIndex(0);
		this.cbDebito.setSelectedIndex(0);
		this.txtDescricao.requestFocus();
	}
	
	public List<String> getNomeContas() throws Exception{
		Collection<ContaVO> contas =  this.logica.gerarBalanco();
		List<String> nomes = new ArrayList<String>();
		
		for(ContaVO conta : contas)
			nomes.add(conta.getNome());
		return nomes;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		int id;
		String descricao;
        String nomeContaCredito;
        String nomeContaDebito;
        double valor;
		id = Integer.parseInt(this.txtOrdem.getText());
		descricao = this.txtDescricao.getText();		
		nomeContaCredito = this.cbCredito.getSelectedItem().toString();		
		nomeContaDebito = this.cbDebito.getSelectedItem().toString();		
		valor = Double.parseDouble(this.txtValor.getText());	
		try {
			this.logica.registrarFatoContabil(id, descricao, nomeContaCredito, nomeContaDebito, valor);
			JOptionPane.showMessageDialog(this, "Fato Registrado");
			this.modelo.updateData();
			this.reset();
		} catch (Exception e) {
			JOptionPane.showMessageDialog(this, "ERRO");			
		}
		
	}

	public ContabilSessao getLogica() {
		return logica;
	}

	public void setContabilSessao(ContabilSessao contabilSessao) {
		this.logica = contabilSessao;
	}
	
	
	
}
