package inf008.persistencia.memory;


import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import inf008.contabil.entidades.Conta;
import inf008.exception.ContaNaoEncontradaException;
import inf008.persistencia.ContaDAO;

public class ContaDAOMemory implements ContaDAO{
	
    private Map<Integer, Conta> contas = new HashMap<Integer, Conta>();
    
    public void save(Conta conta){
    	this.contas.put(conta.getId(), conta);
    }    
    
    
    public Conta findByName(String nome) throws ContaNaoEncontradaException{
        for(Conta atual : this.contas.values())
          if (atual.getNome().equals(nome))
            return atual;
        throw new ContaNaoEncontradaException(nome);  
    }    
    
	@Override
	public void update(Conta conta) throws Exception {
		this.contas.put(conta.getId(), conta);
	}


	@Override
	public Conta findById(int id) throws Exception {
		return this.contas.get(id);
	}


	@Override
	public Collection<Conta> findAll() throws Exception {
		return this.contas.values();
	}    
    
    
}
