package inf008.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

import inf008.contabil.ContabilSessao;
import inf008.contabil.RegistroContabil;
import inf008.ui.vo.ContaVO;
import inf008.ui.vo.LancamentoVO;

public class ContaConsoleUI {
	
	private ContabilSessao logica;
	private BufferedReader reader;
	
	public ContaConsoleUI(){
		this.reader = new BufferedReader(
	            	  new InputStreamReader(
	            			  System.in));
		this.logica = new RegistroContabil("ABC","0000");
	}
	
	
	public boolean showMenu() throws Exception{
		int option;
		System.out.println("Operacoes");
		System.out.println("[1] - Registrar Fato Contabil");
		System.out.println("[2] - Exibir Livro");
		System.out.println("[3] - Exibir Balanco");
		System.out.println("[4] - Adicionar Conta");
		System.out.println("[5] - Listar Contas");
		System.out.println("[0] - Finalizar");
		
		option = Integer.parseInt(this.reader.readLine());
		switch(option){
			case 1 : this.registrarFato(); break; 
			case 2 : this.exibirLivro(); break;
			case 3 : this.exibirBalanco(); break;
			case 4 : this.adicionarConta(); break;
			case 5 : this.listarContas(); break;
			case 0 : return false;
		}
		return true;
		
	}

	private void listarContas() throws Exception {
		System.out.println("Contas");
		List<ContaVO> contas = this.logica.gerarBalanco(); 
		for(ContaVO conta : contas)
			System.out.println("[" + conta.getTipo() + "-" + conta.getId() + "]" + conta.getNome());
		System.out.println("***************");
	}


	private void adicionarConta() throws Exception {
		char tipoConta;
		int id;
		String nome;
		
		System.out.println("Adicionar Conta");
		System.out.println("Tipo da Conta [A | P | L]: ");
		tipoConta = Character.toUpperCase(this.reader.readLine().charAt(0));
		System.out.println("Id da Conta : ");
		id = Integer.parseInt(this.reader.readLine());
		System.out.println("Nome da Conta : ");		
		nome = this.reader.readLine();		
		this.logica.addConta(tipoConta, id, nome);
		System.out.println("Conta Adicionada!");
		
	}


	private void exibirBalanco() throws Exception {
		System.out.println("Livro Contabil");
		List<ContaVO> contas = this.logica.gerarBalanco(); 
		for(ContaVO conta : contas){
			System.out.println("[" + conta.getTipo() + "-" + conta.getId() + "]");
			System.out.println("\t *** ->" + conta.getNome() + "....... R$" + conta.getSaldo());
		}
		System.out.println("***************");	
	}


	private void exibirLivro() throws Exception {
		System.out.println("Livro Contabil");
		List<LancamentoVO> lancamentos = this.logica.gerarLivro(); 
		for(LancamentoVO lancamento : lancamentos){
		  System.out.print("[" +  lancamento.getOrdem() + "] - ");
		  System.out.println(lancamento.getDescricao() + " - R$" + lancamento.getValor());
		  System.out.println("\t[C] - " + lancamento.getNomeCredito());
		  System.out.println("\t[D] - " + lancamento.getNomeDebito());
		}  
		System.out.println("***************");
	}


	private void registrarFato() throws Exception {
		int id;
		String descricao;
        String nomeContaCredito;
        String nomeContaDebito;
        double valor;
		System.out.println("Id do fato : ");
		id = Integer.parseInt(this.reader.readLine());
		System.out.println("Descricao : ");		
		descricao = this.reader.readLine();		
		System.out.println("Conta Credito : ");		
		nomeContaCredito = this.reader.readLine();		
		System.out.println("Conta Debito : ");		
		nomeContaDebito = this.reader.readLine();		
		System.out.println("Valor : ");		
		valor = Double.parseDouble(this.reader.readLine());	
		this.logica.registrarFatoContabil(id, descricao, nomeContaCredito, nomeContaDebito, valor);
		System.out.println("Fato Registrado");		
	}
	
	public void run() throws Exception{
		while(this.showMenu());
	}
	
	public static void main(String[] args) throws Exception {
		(new ContaConsoleUI()).run();
	}
	

}
