package inf008.contabil;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import inf008.exception.ContaNaoEncontradaException;
import inf008.persistencia.ContaDAO;
import inf008.persistencia.LancamentoDAO;
import inf008.persistencia.memory.ContaDAOMemory;
import inf008.persistencia.sql.ContaDAOSQL;
import inf008.persistencia.sql.LancamentoDAOSQL;

public class RegistroContabil{
    private String nomeEmpresa;
    private String cnpjEmpresa;
    private ContaDAO contaDAO;
    private LancamentoDAO lancamentoDAO;    
    

    public RegistroContabil(String nomeEmpresa, String cnpjEmpresa){
        this.setNomeEmpresa(nomeEmpresa);
        this.setCNPJEmpresa(cnpjEmpresa);
        this.contaDAO = new ContaDAOSQL();
        this.lancamentoDAO = new LancamentoDAOSQL();
    }    
    
    public void setNomeEmpresa(String nomeEmpresa){
         this.nomeEmpresa =  nomeEmpresa;
    }    
    
    public void setCNPJEmpresa(String cnpjEmpresa){
        this.cnpjEmpresa =  cnpjEmpresa;
    }
    
    public String getNomeEmpresa(){
         return this.nomeEmpresa;
    } 
    
    public String getCNPJEmpresa(){
         return this.cnpjEmpresa;
    }     
    
    
    public String gerarLivro() throws Exception{
    	List<Lancamento> lancamentos = new ArrayList<Lancamento>();
    	lancamentos.addAll(this.lancamentoDAO.findAll());
        Collections.sort(lancamentos);
        String rep = "";
        for(Lancamento lancamento : lancamentos)
          rep += lancamento + "\n";
        return rep;  
     }     
    
    
    public void registrarFatoContabil(int id, String descricao,
                                      String nomeContaCredito,
                                      String nomeContaDebito,
                                      double valor) throws Exception{
                                          
                                          
      Conta credito = this.contaDAO.findByName(nomeContaCredito);                                      
      Conta debito = this.contaDAO.findByName(nomeContaDebito);
      Lancamento lancamento = new Lancamento(id, descricao, credito, debito, valor);
      this.lancamentoDAO.save(lancamento);
      credito.creditar(valor);
      debito.debitar(valor);
      this.contaDAO.update(credito);
      this.contaDAO.update(debito);
    } 
    
    public void addConta(Conta conta) throws Exception{
         this.contaDAO.save(conta);
    }    
    
}
