package inf008.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TesteJDBC {
	
	public void run2(int id, double saldo, String nome, boolean emUso, char tipo) throws SQLException{
		DriverManager.registerDriver(new org.postgresql.Driver());
		System.out.println("Driver Registrado");
		Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/postgres",
													  "postgres", "");
		System.out.println("Conectado");
		PreparedStatement pStmt = conn.prepareStatement("INSERT INTO CONTA(id, saldo, nome, emUso, tipo) VALUES(?, ?, ?, ?, ?)");
		pStmt.setInt(1, id);
		pStmt.setDouble(2, saldo);
		pStmt.setString(3, nome);
		pStmt.setBoolean(4, emUso);
		pStmt.setString(5, Character.toString(tipo));
		int count = pStmt.executeUpdate();
		System.out.println("Alteradas " + count + " linhas.");
	}
	
	
	
	public void run() throws SQLException{
		DriverManager.registerDriver(new org.postgresql.Driver());
		System.out.println("Driver Registrado");
		Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/postgres",
													  "postgres", "");
		System.out.println("Conectado");
		Statement stmt = conn.createStatement();
		ResultSet rSet = stmt.executeQuery("SELECT id, saldo, nome, emUso, tipo FROM conta");
		System.out.println("Executado");
		while(rSet.next()){
			int id = rSet.getInt("id");
			double saldo = rSet.getDouble("saldo");
			String nome = rSet.getString("nome");
			boolean emUso = rSet.getBoolean("emUso");
			char tipo = rSet.getString("tipo").charAt(0);
			System.out.println(id + "--" + saldo + "-->" + nome + "." + emUso + "/" + tipo);		
		}
		rSet.close();
		stmt.close();
		conn.close();
		
		
	}
	
	
	public static void main(String[] args) throws SQLException {
//		(new TesteJDBC()).run2(150, 0, "ESTOQUE", false, 'A');
		TesteJDBC teste = new TesteJDBC();
		teste.run();
	}

}
