package inf008.contabil;

import inf008.exception.ContaNaoEncontradaException;
import inf008.persistencia.ContaDAO;
import inf008.persistencia.memory.ContaDAOMemory;
import inf008.persistencia.sql.ContaDAOSQL;

public class RegistroContabil{
    private String nomeEmpresa;
    private String cnpjEmpresa;
    private ContaDAO contaDAO;
    private LivroContabil livro;    
    

    public RegistroContabil(String nomeEmpresa, String cnpjEmpresa){
        this.setNomeEmpresa(nomeEmpresa);
        this.setCNPJEmpresa(cnpjEmpresa);
        this.contaDAO = new ContaDAOSQL();
        this.livro = new LivroContabil();
    }    
    
    public void setNomeEmpresa(String nomeEmpresa){
         this.nomeEmpresa =  nomeEmpresa;
    }    
    
    public void setCNPJEmpresa(String cnpjEmpresa){
        this.cnpjEmpresa =  cnpjEmpresa;
    }
    
    public String getNomeEmpresa(){
         return this.nomeEmpresa;
    } 
    
    public String getCNPJEmpresa(){
         return this.cnpjEmpresa;
    }     
    
    public void registrarFatoContabil(int id, String descricao,
                                      String nomeContaCredito,
                                      String nomeContaDebito,
                                      double valor) throws Exception{
                                          
                                          
      Conta credito = this.contaDAO.findByName(nomeContaCredito);                                      
      Conta debito = this.contaDAO.findByName(nomeContaDebito);
      Lancamento lancamento = new Lancamento(id, descricao, credito, debito, valor);
      this.livro.adicionar(lancamento);
      credito.creditar(valor);
      debito.debitar(valor);
      this.contaDAO.update(credito);
      this.contaDAO.update(debito);
    } 
    
    public void addConta(Conta conta) throws Exception{
         this.contaDAO.save(conta);
    }    
    
    public String toString(){
        return       "**** Registro Contabil ****\n" +
                     "* Empresa " + this.getNomeEmpresa() + "\n" + 
                     "* CNPJ " + this.getCNPJEmpresa() + "\n" + 
                     "**** Balanco           ****\n" +
                     this.contaDAO + "\n" + 
                     "**** Livro            ****\n" +
                     this.livro + "\n" + 
                     "**************************\n";
                     
    }    
}
