public abstract class Conta implements Ordenavel, JSonnable{
    private int id;
    private String nome;
    protected double saldo; 
    private boolean emUso;     
    
    public Conta(int id, String nome, double saldo, boolean emUso){
        this.id = id;
        this.setNome(nome);
        this.setSaldo(saldo);    
        this.emUso = emUso;
    }    
    
    public Conta(int id, String nome, double saldo){
        this(id, nome, saldo, true);
    }    
    
    
    public Conta(int id, String nome, boolean emUso){
        this(id, nome, 0, emUso);
    } 
    
    public Conta(int id, String nome){
        this(id, nome, 0);
    } 
    
    
    public void setNome(String nome){
        this.nome = nome;
    }    
    
    public void setSaldo(double saldo){
        this.saldo = saldo;
    }    
    
    public String getNome(){
        return this.nome;
    } 
    
    public double getSaldo(){
        return this.saldo;
    }        
    
    public abstract void debitar(double valor);

    public abstract void creditar(double valor);
    
    public abstract String getTipo(); 
    
    
    public String toString(){
        return "[" + this.getTipo() + "-" + this.id + "]" + this.getNome() + "....... R$" + this.getSaldo();
    }  
    
    public int compare(Ordenavel o){
        Conta outra = (Conta) o;
        return this.id - outra.id;
    }  
    
    
    public String[] getNomeAtributos(){
        String[] nomes = {"id", "tipo", "nome", "saldo", "emUso"};
        return nomes;
    };
    
    public String[] getValoresAtributos(){
        String[] valores = new String[5];
        valores[0] = Integer.toString(this.id);
        valores[1] = this.getTipo();
        valores[2] = this.nome;
        valores[3] = Double.toString(this.saldo);
        valores[4] = Boolean.toString(this.emUso);        
        return valores;
    };    
    
    public int[] getTiposAtributos(){
        int[] tipos = {JSonnable.INT, JSonnable.STRING, JSonnable.STRING, JSonnable.REAL, JSonnable.BOOLEAN};
        return tipos;
        
    };     
    
}
