/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.pooling.IWorldPool;

public class PrismaticJoint
extends Joint {
    public final Vec2 m_localAnchor1;
    public final Vec2 m_localAnchor2;
    public final Vec2 m_localXAxis1;
    public final Vec2 m_localYAxis1;
    public float m_refAngle;
    public final Vec2 m_axis;
    public final Vec2 m_perp;
    public float m_s1;
    public float m_s2;
    public float m_a1;
    public float m_a2;
    public final Mat33 m_K;
    public final Vec3 m_impulse;
    public float m_motorMass;
    public float m_motorImpulse;
    public float m_lowerTranslation;
    public float m_upperTranslation;
    public float m_maxMotorForce;
    public float m_motorSpeed;
    public boolean m_enableLimit;
    public boolean m_enableMotor;
    public LimitState m_limitState;

    public PrismaticJoint(IWorldPool argWorld, PrismaticJointDef def) {
        super(argWorld, def);
        this.m_localAnchor1 = new Vec2(def.localAnchorA);
        this.m_localAnchor2 = new Vec2(def.localAnchorB);
        this.m_localXAxis1 = new Vec2(def.localAxis1);
        this.m_localYAxis1 = new Vec2();
        Vec2.crossToOut(1.0f, this.m_localXAxis1, this.m_localYAxis1);
        this.m_refAngle = def.referenceAngle;
        this.m_impulse = new Vec3();
        this.m_motorMass = 0.0f;
        this.m_motorImpulse = 0.0f;
        this.m_lowerTranslation = def.lowerTranslation;
        this.m_upperTranslation = def.upperTranslation;
        this.m_maxMotorForce = def.maxMotorForce;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableLimit = def.enableLimit;
        this.m_enableMotor = def.enableMotor;
        this.m_limitState = LimitState.INACTIVE;
        this.m_K = new Mat33();
        this.m_axis = new Vec2();
        this.m_perp = new Vec2();
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, argOut);
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
        Vec2 temp = this.pool.popVec2();
        temp.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.z);
        argOut.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(temp).mulLocal(inv_dt);
        this.pool.pushVec2(1);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return inv_dt * this.m_impulse.y;
    }

    public float getJointTranslation() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        Vec2 axis = this.pool.popVec2();
        b1.getWorldPointToOut(this.m_localAnchor1, p1);
        b2.getWorldPointToOut(this.m_localAnchor2, p2);
        p2.subLocal(p1);
        b1.getWorldVectorToOut(this.m_localXAxis1, axis);
        float translation = Vec2.dot(p2, axis);
        this.pool.pushVec2(3);
        return translation;
    }

    public float getJointSpeed() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2[] pc = this.pool.popVec2(9);
        Vec2 temp = pc[0];
        Vec2 r1 = pc[1];
        Vec2 r2 = pc[2];
        Vec2 p1 = pc[3];
        Vec2 p2 = pc[4];
        Vec2 d = pc[5];
        Vec2 axis = pc[6];
        Vec2 temp2 = pc[7];
        Vec2 temp3 = pc[8];
        temp.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
        Mat22.mulToOut(b1.getTransform().R, temp, r1);
        temp.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
        Mat22.mulToOut(b2.getTransform().R, temp, r2);
        p1.set(b1.m_sweep.c).addLocal(r1);
        p2.set(b2.m_sweep.c).addLocal(r2);
        d.set(p2).subLocal(p1);
        b1.getWorldVectorToOut(this.m_localXAxis1, axis);
        Vec2 v1 = b1.m_linearVelocity;
        Vec2 v2 = b2.m_linearVelocity;
        float w1 = b1.m_angularVelocity;
        float w2 = b2.m_angularVelocity;
        Vec2.crossToOut(w1, axis, temp);
        Vec2.crossToOut(w2, r2, temp2);
        Vec2.crossToOut(w1, r1, temp3);
        temp2.addLocal(v2).subLocal(v1).subLocal(temp3);
        float speed = Vec2.dot(d, temp) + Vec2.dot(axis, temp2);
        this.pool.pushVec2(9);
        return speed;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableLimit = flag;
    }

    public float getLowerLimit() {
        return this.m_lowerTranslation;
    }

    public float getUpperLimit() {
        return this.m_upperTranslation;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_lowerTranslation = lower;
        this.m_upperTranslation = upper;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = flag;
    }

    public void setMotorSpeed(float speed) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = speed;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public void setMaxMotorForce(float force) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorForce = force;
    }

    public float getMotorForce() {
        return this.m_motorImpulse;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        this.m_localCenterA.set(b1.getLocalCenter());
        this.m_localCenterB.set(b2.getLocalCenter());
        Transform xf1 = b1.getTransform();
        Transform xf2 = b2.getTransform();
        Vec2 temp = this.pool.popVec2();
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        Vec2 d = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        r2.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(xf1.R, r1, r1);
        Mat22.mulToOut(xf2.R, r2, r2);
        d.set(b2.m_sweep.c).addLocal(r2).subLocal(b1.m_sweep.c).subLocal(r1);
        this.m_invMassA = b1.m_invMass;
        this.m_invIA = b1.m_invI;
        this.m_invMassB = b2.m_invMass;
        this.m_invIB = b2.m_invI;
        Mat22.mulToOut(xf1.R, this.m_localXAxis1, this.m_axis);
        temp.set(d).addLocal(r1);
        this.m_a1 = Vec2.cross(temp, this.m_axis);
        this.m_a2 = Vec2.cross(r2, this.m_axis);
        this.m_motorMass = this.m_invMassA + this.m_invMassB + this.m_invIA * this.m_a1 * this.m_a1 + this.m_invIB * this.m_a2 * this.m_a2;
        if (this.m_motorMass > 1.1920929E-7f) {
            this.m_motorMass = 1.0f / this.m_motorMass;
        }
        Mat22.mulToOut(xf1.R, this.m_localYAxis1, this.m_perp);
        temp.set(d).addLocal(r1);
        this.m_s1 = Vec2.cross(temp, this.m_perp);
        this.m_s2 = Vec2.cross(r2, this.m_perp);
        float m1 = this.m_invMassA;
        float m2 = this.m_invMassB;
        float i1 = this.m_invIA;
        float i2 = this.m_invIB;
        float k11 = m1 + m2 + i1 * this.m_s1 * this.m_s1 + i2 * this.m_s2 * this.m_s2;
        float k12 = i1 * this.m_s1 + i2 * this.m_s2;
        float k13 = i1 * this.m_s1 * this.m_a1 + i2 * this.m_s2 * this.m_a2;
        float k22 = i1 + i2;
        float k23 = i1 * this.m_a1 + i2 * this.m_a2;
        float k33 = m1 + m2 + i1 * this.m_a1 * this.m_a1 + i2 * this.m_a2 * this.m_a2;
        this.m_K.col1.set(k11, k12, k13);
        this.m_K.col2.set(k12, k22, k23);
        this.m_K.col3.set(k13, k23, k33);
        if (this.m_enableLimit) {
            float jointTranslation = Vec2.dot(this.m_axis, d);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (jointTranslation <= this.m_lowerTranslation) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_limitState = LimitState.AT_LOWER;
                    this.m_impulse.z = 0.0f;
                }
            } else if (jointTranslation >= this.m_upperTranslation) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_limitState = LimitState.AT_UPPER;
                    this.m_impulse.z = 0.0f;
                }
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.z = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
            this.m_impulse.z = 0.0f;
        }
        if (!this.m_enableMotor) {
            this.m_motorImpulse = 0.0f;
        }
        if (step.warmStarting) {
            this.m_impulse.mulLocal(step.dtRatio);
            this.m_motorImpulse *= step.dtRatio;
            Vec2 P = this.pool.popVec2();
            temp.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.z);
            P.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(temp);
            float L1 = this.m_impulse.x * this.m_s1 + this.m_impulse.y + (this.m_motorImpulse + this.m_impulse.z) * this.m_a1;
            float L2 = this.m_impulse.x * this.m_s2 + this.m_impulse.y + (this.m_motorImpulse + this.m_impulse.z) * this.m_a2;
            temp.set(P).mulLocal(this.m_invMassA);
            b1.m_linearVelocity.subLocal(temp);
            b1.m_angularVelocity -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            b2.m_linearVelocity.addLocal(temp);
            b2.m_angularVelocity += this.m_invIB * L2;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        this.pool.pushVec2(4);
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        float i1;
        float m2;
        float m1;
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 c1 = b1.m_sweep.c;
        float a1 = b1.m_sweep.a;
        Vec2 c2 = b2.m_sweep.c;
        float a2 = b2.m_sweep.a;
        float linearError = 0.0f;
        float angularError = 0.0f;
        boolean active = false;
        float C2 = 0.0f;
        Mat22 R1 = this.pool.popMat22();
        Mat22 R2 = this.pool.popMat22();
        R1.set(a1);
        R2.set(a2);
        Vec2 temp = this.pool.popVec2();
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        Vec2 d = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        r2.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(R1, r1, r1);
        Mat22.mulToOut(R2, r2, r2);
        d.set(c2).addLocal(r2).subLocal(c1).subLocal(r1);
        if (this.m_enableLimit) {
            Mat22.mulToOut(R1, this.m_localXAxis1, this.m_axis);
            temp.set(d).addLocal(r1);
            this.m_a1 = Vec2.cross(temp, this.m_axis);
            this.m_a2 = Vec2.cross(r2, this.m_axis);
            float translation = Vec2.dot(this.m_axis, d);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                C2 = MathUtils.clamp(translation, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
                linearError = MathUtils.abs(translation);
                active = true;
            } else if (translation <= this.m_lowerTranslation) {
                C2 = MathUtils.clamp(translation - this.m_lowerTranslation + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
                linearError = this.m_lowerTranslation - translation;
                active = true;
            } else if (translation >= this.m_upperTranslation) {
                C2 = MathUtils.clamp(translation - this.m_upperTranslation - Settings.linearSlop, 0.0f, Settings.maxLinearCorrection);
                linearError = translation - this.m_upperTranslation;
                active = true;
            }
        }
        Mat22.mulToOut(R1, this.m_localYAxis1, this.m_perp);
        temp.set(d).addLocal(r1);
        this.m_s1 = Vec2.cross(temp, this.m_perp);
        this.m_s2 = Vec2.cross(r2, this.m_perp);
        Vec3 impulse = this.pool.popVec3();
        Vec2 C1 = this.pool.popVec2();
        C1.x = Vec2.dot(this.m_perp, d);
        C1.y = a2 - a1 - this.m_refAngle;
        linearError = MathUtils.max(linearError, MathUtils.abs(C1.x));
        angularError = MathUtils.abs(C1.y);
        if (active) {
            m1 = this.m_invMassA;
            m2 = this.m_invMassB;
            i1 = this.m_invIA;
            float i2 = this.m_invIB;
            float k11 = m1 + m2 + i1 * this.m_s1 * this.m_s1 + i2 * this.m_s2 * this.m_s2;
            float k12 = i1 * this.m_s1 + i2 * this.m_s2;
            float k13 = i1 * this.m_s1 * this.m_a1 + i2 * this.m_s2 * this.m_a2;
            float k22 = i1 + i2;
            float k23 = i1 * this.m_a1 + i2 * this.m_a2;
            float k33 = m1 + m2 + i1 * this.m_a1 * this.m_a1 + i2 * this.m_a2 * this.m_a2;
            this.m_K.col1.set(k11, k12, k13);
            this.m_K.col2.set(k12, k22, k23);
            this.m_K.col3.set(k13, k23, k33);
            Vec3 C = this.pool.popVec3();
            C.x = C1.x;
            C.y = C1.y;
            C.z = C2;
            this.m_K.solve33ToOut(C.negateLocal(), impulse);
            this.pool.pushVec3(1);
        } else {
            m1 = this.m_invMassA;
            m2 = this.m_invMassB;
            i1 = this.m_invIA;
            float i2 = this.m_invIB;
            float k11 = m1 + m2 + i1 * this.m_s1 * this.m_s1 + i2 * this.m_s2 * this.m_s2;
            float k12 = i1 * this.m_s1 + i2 * this.m_s2;
            float k22 = i1 + i2;
            this.m_K.col1.set(k11, k12, 0.0f);
            this.m_K.col2.set(k12, k22, 0.0f);
            this.m_K.solve22ToOut(C1.negateLocal(), temp);
            C1.negateLocal();
            impulse.x = temp.x;
            impulse.y = temp.y;
            impulse.z = 0.0f;
        }
        Vec2 P = this.pool.popVec2();
        temp.set(this.m_perp).mulLocal(impulse.x);
        P.set(this.m_axis).mulLocal(impulse.z).addLocal(temp);
        float L1 = impulse.x * this.m_s1 + impulse.y + impulse.z * this.m_a1;
        float L2 = impulse.x * this.m_s2 + impulse.y + impulse.z * this.m_a2;
        temp.set(P).mulLocal(this.m_invMassA);
        c1.subLocal(temp);
        a1 -= this.m_invIA * L1;
        temp.set(P).mulLocal(this.m_invMassB);
        c2.addLocal(temp);
        a2 += this.m_invIB * L2;
        b1.m_sweep.c.set(c1);
        b1.m_sweep.a = a1;
        b2.m_sweep.c.set(c2);
        b2.m_sweep.a = a2;
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        this.pool.pushVec2(6);
        this.pool.pushVec3(1);
        this.pool.pushMat22(2);
        return linearError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 v1 = b1.m_linearVelocity;
        float w1 = b1.m_angularVelocity;
        Vec2 v2 = b2.m_linearVelocity;
        float w2 = b2.m_angularVelocity;
        Vec2 temp = this.pool.popVec2();
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL) {
            temp.set(v2).subLocal(v1);
            float Cdot = Vec2.dot(this.m_axis, temp) + this.m_a2 * w2 - this.m_a1 * w1;
            float impulse = this.m_motorMass * (this.m_motorSpeed - Cdot);
            float oldImpulse = this.m_motorImpulse;
            float maxImpulse = step.dt * this.m_maxMotorForce;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.m_motorImpulse - oldImpulse;
            Vec2 P = this.pool.popVec2();
            P.set(this.m_axis).mulLocal(impulse);
            float L1 = impulse * this.m_a1;
            float L2 = impulse * this.m_a2;
            temp.set(P).mulLocal(this.m_invMassA);
            v1.subLocal(temp);
            w1 -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            v2.addLocal(temp);
            w2 += this.m_invIB * L2;
            this.pool.pushVec2(1);
        }
        Vec2 Cdot1 = this.pool.popVec2();
        temp.set(v2).subLocal(v1);
        Cdot1.x = Vec2.dot(this.m_perp, temp) + this.m_s2 * w2 - this.m_s1 * w1;
        Cdot1.y = w2 - w1;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            temp.set(v2).subLocal(v1);
            float Cdot2 = Vec2.dot(this.m_axis, temp) + this.m_a2 * w2 - this.m_a1 * w1;
            Vec3 Cdot = this.pool.popVec3();
            Cdot.set(Cdot1.x, Cdot1.y, Cdot2);
            Cdot.negateLocal();
            Vec3 f1 = this.pool.popVec3();
            f1.set(this.m_impulse);
            Vec3 df = this.pool.popVec3();
            this.m_K.solve33ToOut(Cdot, df);
            this.m_impulse.addLocal(df);
            if (this.m_limitState == LimitState.AT_LOWER) {
                this.m_impulse.z = MathUtils.max(this.m_impulse.z, 0.0f);
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                this.m_impulse.z = MathUtils.min(this.m_impulse.z, 0.0f);
            }
            Vec2 b = this.pool.popVec2();
            Vec2 f2r = this.pool.popVec2();
            temp.set(this.m_K.col3.x, this.m_K.col3.y).mulLocal(this.m_impulse.z - f1.z);
            b.set(Cdot1).negateLocal().subLocal(temp);
            temp.set(f1.x, f1.y);
            this.m_K.solve22ToOut(b, f2r);
            f2r.addLocal(temp);
            this.m_impulse.x = f2r.x;
            this.m_impulse.y = f2r.y;
            df.set(this.m_impulse).subLocal(f1);
            Vec2 P = this.pool.popVec2();
            temp.set(this.m_axis).mulLocal(df.z);
            P.set(this.m_perp).mulLocal(df.x).addLocal(temp);
            float L1 = df.x * this.m_s1 + df.y + df.z * this.m_a1;
            float L2 = df.x * this.m_s2 + df.y + df.z * this.m_a2;
            temp.set(P).mulLocal(this.m_invMassA);
            v1.subLocal(temp);
            w1 -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            v2.addLocal(temp);
            w2 += this.m_invIB * L2;
            this.pool.pushVec2(3);
            this.pool.pushVec3(3);
        } else {
            Vec2 df = this.pool.popVec2();
            this.m_K.solve22ToOut(Cdot1.negateLocal(), df);
            Cdot1.negateLocal();
            this.m_impulse.x += df.x;
            this.m_impulse.y += df.y;
            Vec2 P = this.pool.popVec2();
            P.set(this.m_perp).mulLocal(df.x);
            float L1 = df.x * this.m_s1 + df.y;
            float L2 = df.x * this.m_s2 + df.y;
            temp.set(P).mulLocal(this.m_invMassA);
            v1.subLocal(temp);
            w1 -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            v2.addLocal(temp);
            w2 += this.m_invIB * L2;
            this.pool.pushVec2(2);
        }
        b1.m_linearVelocity.set(v1);
        b1.m_angularVelocity = w1;
        b2.m_linearVelocity.set(v2);
        b2.m_angularVelocity = w2;
        this.pool.pushVec2(2);
    }
}

