/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Vec2;

public class Jacobian {
    public final Vec2 linearA = new Vec2();
    public float angularA;
    public final Vec2 linearB = new Vec2();
    public float angularB;

    public void setZero() {
        this.linearA.setZero();
        this.linearB.setZero();
        this.angularA = 0.0f;
        this.angularB = 0.0f;
    }

    public void set(Vec2 x1, float a1, Vec2 x2, float a2) {
        this.linearA.set(x1);
        this.linearB.set(x2);
        this.angularA = a1;
        this.angularB = a2;
    }

    public float compute(Vec2 x1, float a1, Vec2 x2, float a2) {
        return Vec2.dot(this.linearA, x1) + this.angularA * a1 + Vec2.dot(this.linearB, x2) + this.angularB * a2;
    }
}

