/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.pooling.IWorldPool;

public class MouseJoint
extends Joint {
    private final Vec2 m_localAnchor = new Vec2();
    private final Vec2 m_target = new Vec2();
    private final Vec2 m_impulse = new Vec2();
    private final Mat22 m_mass = new Mat22();
    private final Vec2 m_C = new Vec2();
    private float m_maxForce;
    private float m_frequencyHz;
    private float m_dampingRatio;
    private float m_beta;
    private float m_gamma;

    protected MouseJoint(IWorldPool argWorld, MouseJointDef def) {
        super(argWorld, def);
        assert (def.target.isValid());
        assert (def.maxForce >= 0.0f);
        assert (def.frequencyHz >= 0.0f);
        assert (def.dampingRatio >= 0.0f);
        this.m_target.set(def.target);
        Transform.mulTransToOut(this.m_bodyB.getTransform(), this.m_target, this.m_localAnchor);
        this.m_maxForce = def.maxForce;
        this.m_impulse.setZero();
        this.m_frequencyHz = def.frequencyHz;
        this.m_dampingRatio = def.dampingRatio;
        this.m_beta = 0.0f;
        this.m_gamma = 0.0f;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        argOut.set(this.m_target);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.m_impulse).mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return invDt * 0.0f;
    }

    public void setTarget(Vec2 target) {
        if (!this.m_bodyB.isAwake()) {
            this.m_bodyB.setAwake(true);
        }
        this.m_target.set(target);
    }

    public Vec2 getTarget() {
        return this.m_target;
    }

    public void setMaxForce(float force) {
        this.m_maxForce = force;
    }

    public float getMaxForce() {
        return this.m_maxForce;
    }

    public void setFrequency(float hz) {
        this.m_frequencyHz = hz;
    }

    public float getFrequency() {
        return this.m_frequencyHz;
    }

    public void setDampingRatio(float ratio) {
        this.m_dampingRatio = ratio;
    }

    public float getDampingRatio() {
        return this.m_dampingRatio;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b = this.m_bodyB;
        float mass = b.getMass();
        float omega = (float)Math.PI * 2 * this.m_frequencyHz;
        float d = 2.0f * mass * this.m_dampingRatio * omega;
        float k = mass * (omega * omega);
        assert (d + step.dt * k > 1.1920929E-7f);
        this.m_gamma = step.dt * (d + step.dt * k);
        if (this.m_gamma != 0.0f) {
            this.m_gamma = 1.0f / this.m_gamma;
        }
        this.m_beta = step.dt * k * this.m_gamma;
        Vec2 r = this.pool.popVec2();
        r.set(this.m_localAnchor).subLocal(b.getLocalCenter());
        Mat22.mulToOut(b.getTransform().R, r, r);
        float invMass = b.m_invMass;
        float invI = b.m_invI;
        Mat22 K1 = this.pool.popMat22();
        K1.col1.x = invMass;
        K1.col2.x = 0.0f;
        K1.col1.y = 0.0f;
        K1.col2.y = invMass;
        Mat22 K2 = this.pool.popMat22();
        K2.col1.x = invI * r.y * r.y;
        K2.col2.x = -invI * r.x * r.y;
        K2.col1.y = -invI * r.x * r.y;
        K2.col2.y = invI * r.x * r.x;
        Mat22 K = this.pool.popMat22();
        K.set(K1).addLocal(K2);
        K.col1.x += this.m_gamma;
        K.col2.y += this.m_gamma;
        K.invertToOut(this.m_mass);
        this.m_C.set(b.m_sweep.c).addLocal(r).subLocal(this.m_target);
        b.m_angularVelocity *= 0.98f;
        this.m_impulse.mulLocal(step.dtRatio);
        Vec2 temp = this.pool.popVec2();
        temp.set(this.m_impulse).mulLocal(invMass);
        b.m_linearVelocity.addLocal(temp);
        b.m_angularVelocity += invI * Vec2.cross(r, this.m_impulse);
        this.pool.pushVec2(2);
        this.pool.pushMat22(3);
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        return true;
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b = this.m_bodyB;
        Vec2 r = this.pool.popVec2();
        r.set(this.m_localAnchor).subLocal(b.getLocalCenter());
        Mat22.mulToOut(b.getTransform().R, r, r);
        Vec2 Cdot = this.pool.popVec2();
        Vec2.crossToOut(b.m_angularVelocity, r, Cdot);
        Cdot.addLocal(b.m_linearVelocity);
        Vec2 impulse = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        impulse.set(this.m_C).mulLocal(this.m_beta);
        temp.set(this.m_impulse).mulLocal(this.m_gamma);
        temp.addLocal(impulse).addLocal(Cdot).mulLocal(-1.0f);
        Mat22.mulToOut(this.m_mass, temp, impulse);
        Vec2 oldImpulse = temp;
        oldImpulse.set(this.m_impulse);
        this.m_impulse.addLocal(impulse);
        float maxImpulse = step.dt * this.m_maxForce;
        if (this.m_impulse.lengthSquared() > maxImpulse * maxImpulse) {
            this.m_impulse.mulLocal(maxImpulse / this.m_impulse.length());
        }
        impulse.set(this.m_impulse).subLocal(oldImpulse);
        oldImpulse.set(impulse).mulLocal(b.m_invMass);
        b.m_linearVelocity.addLocal(oldImpulse);
        b.m_angularVelocity += b.m_invI * Vec2.cross(r, impulse);
        this.pool.pushVec2(4);
    }
}

