/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.contacts.ContactConstraint;

class PositionSolverManifold {
    public final Vec2 normal = new Vec2();
    public final Vec2 point = new Vec2();
    public float separation;
    private final Vec2 pointA = new Vec2();
    private final Vec2 pointB = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 clipPoint = new Vec2();

    PositionSolverManifold() {
    }

    public void initialize(ContactConstraint cc, int index) {
        assert (cc.pointCount > 0);
        switch (cc.type) {
            case CIRCLES: {
                cc.bodyA.getWorldPointToOut(cc.localPoint, this.pointA);
                cc.bodyB.getWorldPointToOut(cc.points[0].localPoint, this.pointB);
                if (MathUtils.distanceSquared(this.pointA, this.pointB) > 1.4210855E-14f) {
                    this.normal.set(this.pointB).subLocal(this.pointA);
                    this.normal.normalize();
                } else {
                    this.normal.set(1.0f, 0.0f);
                }
                this.point.set(this.pointA).addLocal(this.pointB).mulLocal(0.5f);
                this.temp.set(this.pointB).subLocal(this.pointA);
                this.separation = Vec2.dot(this.temp, this.normal) - cc.radius;
                break;
            }
            case FACE_A: {
                cc.bodyA.getWorldVectorToOut(cc.localNormal, this.normal);
                cc.bodyA.getWorldPointToOut(cc.localPoint, this.planePoint);
                cc.bodyB.getWorldPointToOut(cc.points[index].localPoint, this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - cc.radius;
                this.point.set(this.clipPoint);
                break;
            }
            case FACE_B: {
                cc.bodyB.getWorldVectorToOut(cc.localNormal, this.normal);
                cc.bodyB.getWorldPointToOut(cc.localPoint, this.planePoint);
                cc.bodyA.getWorldPointToOut(cc.points[index].localPoint, this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - cc.radius;
                this.point.set(this.clipPoint);
                this.normal.negateLocal();
            }
        }
    }
}

