/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.Position;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.Velocity;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactSolver;
import org.jbox2d.dynamics.joints.Joint;

public class Island {
    public ContactListener m_listener;
    public Body[] m_bodies;
    public Contact[] m_contacts;
    public Joint[] m_joints;
    public Position[] m_positions;
    public Velocity[] m_velocities;
    public int m_bodyCount;
    public int m_jointCount;
    public int m_contactCount;
    public int m_bodyCapacity;
    public int m_contactCapacity;
    public int m_jointCapacity;
    public int m_positionIterationCount;
    private final ContactSolver contactSolver = new ContactSolver();
    private final Vec2 translation = new Vec2();
    private final ContactImpulse impulse = new ContactImpulse();

    public void init(int bodyCapacity, int contactCapacity, int jointCapacity, ContactListener listener) {
        int i;
        Object[] old;
        this.m_bodyCapacity = bodyCapacity;
        this.m_contactCapacity = contactCapacity;
        this.m_jointCapacity = jointCapacity;
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
        this.m_listener = listener;
        if (this.m_bodies == null || this.m_bodyCapacity > this.m_bodies.length) {
            this.m_bodies = new Body[this.m_bodyCapacity];
        }
        if (this.m_joints == null || this.m_jointCapacity > this.m_joints.length) {
            this.m_joints = new Joint[this.m_jointCapacity];
        }
        if (this.m_contacts == null || this.m_contactCapacity > this.m_contacts.length) {
            this.m_contacts = new Contact[this.m_contactCapacity];
        }
        if (this.m_velocities == null || this.m_bodyCapacity > this.m_velocities.length) {
            old = this.m_velocities == null ? new Velocity[]{} : this.m_velocities;
            this.m_velocities = new Velocity[this.m_bodyCapacity];
            System.arraycopy(old, 0, this.m_velocities, 0, old.length);
            for (i = old.length; i < this.m_velocities.length; ++i) {
                this.m_velocities[i] = new Velocity();
            }
        }
        if (this.m_positions == null || this.m_bodyCapacity > this.m_positions.length) {
            old = this.m_positions == null ? new Position[]{} : this.m_positions;
            this.m_positions = new Position[this.m_bodyCapacity];
            System.arraycopy(old, 0, this.m_positions, 0, old.length);
            for (i = old.length; i < this.m_positions.length; ++i) {
                this.m_positions[i] = new Position();
            }
        }
    }

    public void clear() {
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
    }

    public void solve(TimeStep step, Vec2 gravity, boolean allowSleep) {
        int i;
        for (int i2 = 0; i2 < this.m_bodyCount; ++i2) {
            Body b = this.m_bodies[i2];
            if (b.getType() != BodyType.DYNAMIC) continue;
            b.m_linearVelocity.x += (b.m_force.x * b.m_invMass + gravity.x) * step.dt;
            b.m_linearVelocity.y += (b.m_force.y * b.m_invMass + gravity.y) * step.dt;
            b.m_angularVelocity += step.dt * b.m_invI * b.m_torque;
            float a = 1.0f - step.dt * b.m_linearDamping;
            float a1 = 0.0f > (a < 1.0f ? a : 1.0f) ? 0.0f : (a < 1.0f ? a : 1.0f);
            b.m_linearVelocity.x *= a1;
            b.m_linearVelocity.y *= a1;
            float a2 = 1.0f - step.dt * b.m_angularDamping;
            float b1 = a2 < 1.0f ? a2 : 1.0f;
            b.m_angularVelocity = b.m_angularVelocity * (0.0f > b1 ? 0.0f : b1);
        }
        int i1 = -1;
        for (int i2 = 0; i2 < this.m_contactCount; ++i2) {
            boolean nonStatic;
            Fixture fixtureA = this.m_contacts[i2].getFixtureA();
            Fixture fixtureB = this.m_contacts[i2].getFixtureB();
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            boolean bl = nonStatic = bodyA.getType() != BodyType.STATIC && bodyB.getType() != BodyType.STATIC;
            if (!nonStatic) continue;
            Contact temp = this.m_contacts[++i1];
            this.m_contacts[i1] = this.m_contacts[i2];
            this.m_contacts[i2] = temp;
        }
        this.contactSolver.init(this.m_contacts, this.m_contactCount, step.dtRatio);
        this.contactSolver.warmStart();
        for (i = 0; i < this.m_jointCount; ++i) {
            this.m_joints[i].initVelocityConstraints(step);
        }
        for (i = 0; i < step.velocityIterations; ++i) {
            for (int j = 0; j < this.m_jointCount; ++j) {
                this.m_joints[j].solveVelocityConstraints(step);
            }
            this.contactSolver.solveVelocityConstraints();
        }
        this.contactSolver.storeImpulses();
        for (i = 0; i < this.m_bodyCount; ++i) {
            float rotation;
            Body b = this.m_bodies[i];
            if (b.getType() == BodyType.STATIC) continue;
            this.translation.set(b.m_linearVelocity).mulLocal(step.dt);
            if (Vec2.dot(this.translation, this.translation) > Settings.maxTranslationSquared) {
                float ratio = Settings.maxTranslation / this.translation.length();
                b.m_linearVelocity.x *= ratio;
                b.m_linearVelocity.y *= ratio;
            }
            if ((rotation = step.dt * b.m_angularVelocity) * rotation > Settings.maxRotationSquared) {
                float ratio = Settings.maxRotation / Math.abs(rotation);
                b.m_angularVelocity *= ratio;
            }
            b.m_sweep.c0.set(b.m_sweep.c);
            b.m_sweep.a0 = b.m_sweep.a;
            b.m_sweep.c.x += b.m_linearVelocity.x * step.dt;
            b.m_sweep.c.y += b.m_linearVelocity.y * step.dt;
            b.m_sweep.a += step.dt * b.m_angularVelocity;
            b.synchronizeTransform();
        }
        for (i = 0; i < step.positionIterations; ++i) {
            boolean contactsOkay = this.contactSolver.solvePositionConstraints(Settings.contactBaumgarte);
            boolean jointsOkay = true;
            for (int j = 0; j < this.m_jointCount; ++j) {
                boolean jointOkay = this.m_joints[j].solvePositionConstraints(Settings.contactBaumgarte);
                jointsOkay = jointsOkay && jointOkay;
            }
            if (contactsOkay && jointsOkay) break;
        }
        this.report(this.contactSolver.m_constraints);
        if (allowSleep) {
            int i3;
            float minSleepTime = Float.MAX_VALUE;
            float linTolSqr = Settings.linearSleepTolerance * Settings.linearSleepTolerance;
            float angTolSqr = Settings.angularSleepTolerance * Settings.angularSleepTolerance;
            for (i3 = 0; i3 < this.m_bodyCount; ++i3) {
                Body b = this.m_bodies[i3];
                if (b.getType() == BodyType.STATIC) continue;
                if ((b.m_flags & 4) == 0) {
                    b.m_sleepTime = 0.0f;
                    minSleepTime = 0.0f;
                }
                Vec2 linVel = b.m_linearVelocity;
                if ((b.m_flags & 4) == 0 || b.m_angularVelocity * b.m_angularVelocity > angTolSqr || linVel.x * linVel.x + linVel.y * linVel.y > linTolSqr) {
                    b.m_sleepTime = 0.0f;
                    minSleepTime = 0.0f;
                    continue;
                }
                b.m_sleepTime += step.dt;
                minSleepTime = MathUtils.min(minSleepTime, b.m_sleepTime);
            }
            if (minSleepTime >= Settings.timeToSleep) {
                for (i3 = 0; i3 < this.m_bodyCount; ++i3) {
                    Body b = this.m_bodies[i3];
                    b.setAwake(false);
                }
            }
        }
    }

    public void add(Body body) {
        assert (this.m_bodyCount < this.m_bodyCapacity);
        body.m_islandIndex = this.m_bodyCount;
        this.m_bodies[this.m_bodyCount++] = body;
    }

    public void add(Contact contact) {
        assert (this.m_contactCount < this.m_contactCapacity);
        this.m_contacts[this.m_contactCount++] = contact;
    }

    public void add(Joint joint) {
        assert (this.m_jointCount < this.m_jointCapacity);
        this.m_joints[this.m_jointCount++] = joint;
    }

    public void report(ContactConstraint[] constraints) {
        if (this.m_listener == null) {
            return;
        }
        for (int i = 0; i < this.m_contactCount; ++i) {
            Contact c = this.m_contacts[i];
            ContactConstraint cc = constraints[i];
            for (int j = 0; j < cc.pointCount; ++j) {
                this.impulse.normalImpulses[j] = cc.points[j].normalImpulse;
                this.impulse.tangentImpulses[j] = cc.points[j].tangentImpulse;
            }
            this.m_listener.postSolve(c, this.impulse);
        }
    }
}

