/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.callbacks.ContactFilter;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.DestructionListener;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.ContactManager;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.Island;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.WorldQueryWrapper;
import org.jbox2d.dynamics.WorldRayCastWrapper;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.contacts.ContactRegister;
import org.jbox2d.dynamics.contacts.TOISolver;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.pooling.IDynamicStack;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.arrays.Vec2Array;
import org.jbox2d.pooling.normal.DefaultWorldPool;

public class World {
    public static final int WORLD_POOL_SIZE = 100;
    public static final int WORLD_POOL_CONTAINER_SIZE = 10;
    public static final int NEW_FIXTURE = 1;
    public static final int LOCKED = 2;
    public static final int CLEAR_FORCES = 4;
    public int activeContacts = 0;
    public int contactPoolCount = 0;
    protected int m_flags;
    protected ContactManager m_contactManager;
    private Body m_bodyList;
    private Joint m_jointList;
    private int m_bodyCount;
    private int m_jointCount;
    private final Vec2 m_gravity = new Vec2();
    private boolean m_allowSleep;
    private DestructionListener m_destructionListener;
    private DebugDraw m_debugDraw;
    private final IWorldPool pool;
    private float m_inv_dt0;
    private boolean m_warmStarting;
    private boolean m_continuousPhysics;
    private ContactRegister[][] contactStacks = new ContactRegister[2][2];
    private final TimeStep step = new TimeStep();
    private final Color3f color = new Color3f();
    private final Transform xf = new Transform();
    private final Vec2 cA = new Vec2();
    private final Vec2 cB = new Vec2();
    private final Vec2Array avs = new Vec2Array();
    private final WorldQueryWrapper wqwrapper = new WorldQueryWrapper();
    private final WorldRayCastWrapper wrcwrapper = new WorldRayCastWrapper();
    private final RayCastInput input = new RayCastInput();
    private final Island island = new Island();
    private Body[] stack = new Body[10];
    private final TimeOfImpact.TOIInput toiInput = new TimeOfImpact.TOIInput();
    private final TimeOfImpact.TOIOutput toiOutput = new TimeOfImpact.TOIOutput();
    private final Sweep backup = new Sweep();
    private final TOISolver toiSolver = new TOISolver();
    private Contact[] m_contacts = new Contact[Settings.maxTOIContacts];
    private static Integer LIQUID_INT = new Integer(1234598372);
    private float liquidLength = 0.12f;
    private float averageLinearVel = -1.0f;
    private final Vec2 liquidOffset = new Vec2();
    private final Vec2 circCenterMoved = new Vec2();
    private final Color3f liquidColor = new Color3f(0.4f, 0.4f, 1.0f);
    private final Vec2 center = new Vec2();
    private final Vec2 axis = new Vec2();
    private final Vec2Array tlvertices = new Vec2Array();

    public World(Vec2 gravity, boolean doSleep) {
        this(gravity, doSleep, new DefaultWorldPool(100, 10));
    }

    public World(Vec2 gravity, boolean doSleep, IWorldPool argPool) {
        this.pool = argPool;
        this.m_destructionListener = null;
        this.m_debugDraw = null;
        this.m_bodyList = null;
        this.m_jointList = null;
        this.m_bodyCount = 0;
        this.m_jointCount = 0;
        this.m_warmStarting = true;
        this.m_continuousPhysics = true;
        this.m_allowSleep = doSleep;
        this.m_gravity.set(gravity);
        this.m_flags = 4;
        this.m_inv_dt0 = 0.0f;
        this.m_contactManager = new ContactManager(this);
        this.initializeRegisters();
    }

    public void setAllowSleep(boolean argAllowSleep) {
        this.m_allowSleep = argAllowSleep;
    }

    public boolean isAllowSleep() {
        return this.m_allowSleep;
    }

    private void addType(IDynamicStack<Contact> creator, ShapeType type1, ShapeType type2) {
        ContactRegister register = new ContactRegister();
        register.creator = creator;
        register.primary = true;
        this.contactStacks[type1.intValue][type2.intValue] = register;
        if (type1 != type2) {
            ContactRegister register2 = new ContactRegister();
            register2.creator = creator;
            register2.primary = false;
            this.contactStacks[type2.intValue][type1.intValue] = register2;
        }
    }

    private void initializeRegisters() {
        this.addType(this.pool.getCircleContactStack(), ShapeType.CIRCLE, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyCircleContactStack(), ShapeType.POLYGON, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyContactStack(), ShapeType.POLYGON, ShapeType.POLYGON);
    }

    public Contact popContact(Fixture fixtureA, Fixture fixtureB) {
        ShapeType type1 = fixtureA.getType();
        ShapeType type2 = fixtureB.getType();
        ContactRegister reg = this.contactStacks[type1.intValue][type2.intValue];
        IDynamicStack<Contact> creator = reg.creator;
        if (creator != null) {
            if (reg.primary) {
                Contact c = creator.pop();
                c.init(fixtureA, fixtureB);
                return c;
            }
            Contact c = creator.pop();
            c.init(fixtureB, fixtureA);
            return c;
        }
        return null;
    }

    public void pushContact(Contact contact) {
        if (contact.m_manifold.pointCount > 0) {
            contact.getFixtureA().getBody().setAwake(true);
            contact.getFixtureB().getBody().setAwake(true);
        }
        ShapeType type1 = contact.getFixtureA().getType();
        ShapeType type2 = contact.getFixtureB().getType();
        IDynamicStack<Contact> creator = this.contactStacks[type1.intValue][type2.intValue].creator;
        creator.push(contact);
    }

    public IWorldPool getPool() {
        return this.pool;
    }

    public void setDestructionListener(DestructionListener listener) {
        this.m_destructionListener = listener;
    }

    public void setContactFilter(ContactFilter filter) {
        this.m_contactManager.m_contactFilter = filter;
    }

    public void setContactListener(ContactListener listener) {
        this.m_contactManager.m_contactListener = listener;
    }

    public void setDebugDraw(DebugDraw debugDraw) {
        this.m_debugDraw = debugDraw;
    }

    public Body createBody(BodyDef def) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Body b = new Body(def, this);
        b.m_prev = null;
        b.m_next = this.m_bodyList;
        if (this.m_bodyList != null) {
            this.m_bodyList.m_prev = b;
        }
        this.m_bodyList = b;
        ++this.m_bodyCount;
        return b;
    }

    public void destroyBody(Body body) {
        assert (this.m_bodyCount > 0);
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        JointEdge je = body.m_jointList;
        while (je != null) {
            JointEdge je0 = je;
            je = je.next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(je0.joint);
            }
            this.destroyJoint(je0.joint);
        }
        body.m_jointList = null;
        ContactEdge ce = body.m_contactList;
        while (ce != null) {
            ContactEdge ce0 = ce;
            ce = ce.next;
            this.m_contactManager.destroy(ce0.contact);
        }
        body.m_contactList = null;
        Fixture f = body.m_fixtureList;
        while (f != null) {
            Fixture f0 = f;
            f = f.m_next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(f0);
            }
            f0.destroyProxy(this.m_contactManager.m_broadPhase);
            f0.destroy();
        }
        body.m_fixtureList = null;
        body.m_fixtureCount = 0;
        if (body.m_prev != null) {
            body.m_prev.m_next = body.m_next;
        }
        if (body.m_next != null) {
            body.m_next.m_prev = body.m_prev;
        }
        if (body == this.m_bodyList) {
            this.m_bodyList = body.m_next;
        }
        --this.m_bodyCount;
    }

    public Joint createJoint(JointDef def) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Joint j = Joint.create(this, def);
        j.m_prev = null;
        j.m_next = this.m_jointList;
        if (this.m_jointList != null) {
            this.m_jointList.m_prev = j;
        }
        this.m_jointList = j;
        ++this.m_jointCount;
        j.m_edgeA.joint = j;
        j.m_edgeA.other = j.m_bodyB;
        j.m_edgeA.prev = null;
        j.m_edgeA.next = j.m_bodyA.m_jointList;
        if (j.m_bodyA.m_jointList != null) {
            j.m_bodyA.m_jointList.prev = j.m_edgeA;
        }
        j.m_bodyA.m_jointList = j.m_edgeA;
        j.m_edgeB.joint = j;
        j.m_edgeB.other = j.m_bodyA;
        j.m_edgeB.prev = null;
        j.m_edgeB.next = j.m_bodyB.m_jointList;
        if (j.m_bodyB.m_jointList != null) {
            j.m_bodyB.m_jointList.prev = j.m_edgeB;
        }
        j.m_bodyB.m_jointList = j.m_edgeB;
        Body bodyA = def.bodyA;
        Body bodyB = def.bodyB;
        if (!def.collideConnected) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
        return j;
    }

    public void destroyJoint(Joint j) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        boolean collideConnected = j.m_collideConnected;
        if (j.m_prev != null) {
            j.m_prev.m_next = j.m_next;
        }
        if (j.m_next != null) {
            j.m_next.m_prev = j.m_prev;
        }
        if (j == this.m_jointList) {
            this.m_jointList = j.m_next;
        }
        Body bodyA = j.m_bodyA;
        Body bodyB = j.m_bodyB;
        bodyA.setAwake(true);
        bodyB.setAwake(true);
        if (j.m_edgeA.prev != null) {
            j.m_edgeA.prev.next = j.m_edgeA.next;
        }
        if (j.m_edgeA.next != null) {
            j.m_edgeA.next.prev = j.m_edgeA.prev;
        }
        if (j.m_edgeA == bodyA.m_jointList) {
            bodyA.m_jointList = j.m_edgeA.next;
        }
        j.m_edgeA.prev = null;
        j.m_edgeA.next = null;
        if (j.m_edgeB.prev != null) {
            j.m_edgeB.prev.next = j.m_edgeB.next;
        }
        if (j.m_edgeB.next != null) {
            j.m_edgeB.next.prev = j.m_edgeB.prev;
        }
        if (j.m_edgeB == bodyB.m_jointList) {
            bodyB.m_jointList = j.m_edgeB.next;
        }
        j.m_edgeB.prev = null;
        j.m_edgeB.next = null;
        Joint.destroy(j);
        assert (this.m_jointCount > 0);
        --this.m_jointCount;
        if (!collideConnected) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
    }

    public void step(float dt, int velocityIterations, int positionIterations) {
        if ((this.m_flags & 1) == 1) {
            this.m_contactManager.findNewContacts();
            this.m_flags &= 0xFFFFFFFE;
        }
        this.m_flags |= 2;
        this.step.dt = dt;
        this.step.velocityIterations = velocityIterations;
        this.step.positionIterations = positionIterations;
        this.step.inv_dt = dt > 0.0f ? 1.0f / dt : 0.0f;
        this.step.dtRatio = this.m_inv_dt0 * dt;
        this.step.warmStarting = this.m_warmStarting;
        this.m_contactManager.collide();
        if (this.step.dt > 0.0f) {
            this.solve(this.step);
        }
        if (this.m_continuousPhysics && this.step.dt > 0.0f) {
            this.solveTOI();
        }
        if (this.step.dt > 0.0f) {
            this.m_inv_dt0 = this.step.inv_dt;
        }
        if ((this.m_flags & 4) == 4) {
            this.clearForces();
        }
        this.m_flags &= 0xFFFFFFFD;
    }

    public void clearForces() {
        for (Body body = this.m_bodyList; body != null; body = body.getNext()) {
            body.m_force.setZero();
            body.m_torque = 0.0f;
        }
    }

    public void drawDebugData() {
        Fixture f;
        Body b;
        if (this.m_debugDraw == null) {
            return;
        }
        int flags = this.m_debugDraw.getFlags();
        if ((flags & 1) == 1) {
            for (b = this.m_bodyList; b != null; b = b.getNext()) {
                this.xf.set(b.getTransform());
                for (f = b.getFixtureList(); f != null; f = f.getNext()) {
                    if (!b.isActive()) {
                        this.color.set(0.5f, 0.5f, 0.3f);
                        this.drawShape(f, this.xf, this.color);
                        continue;
                    }
                    if (b.getType() == BodyType.STATIC) {
                        this.color.set(0.5f, 0.9f, 0.3f);
                        this.drawShape(f, this.xf, this.color);
                        continue;
                    }
                    if (b.getType() == BodyType.KINEMATIC) {
                        this.color.set(0.5f, 0.5f, 0.9f);
                        this.drawShape(f, this.xf, this.color);
                        continue;
                    }
                    if (!b.isAwake()) {
                        this.color.set(0.5f, 0.5f, 0.5f);
                        this.drawShape(f, this.xf, this.color);
                        continue;
                    }
                    this.color.set(0.9f, 0.7f, 0.7f);
                    this.drawShape(f, this.xf, this.color);
                }
            }
        }
        if ((flags & 2) == 2) {
            for (Joint j = this.m_jointList; j != null; j = j.getNext()) {
                this.drawJoint(j);
            }
        }
        if ((flags & 8) == 8) {
            this.color.set(0.3f, 0.9f, 0.9f);
            for (Contact c = this.m_contactManager.m_contactList; c != null; c = c.getNext()) {
                Fixture fixtureA = c.getFixtureA();
                Fixture fixtureB = c.getFixtureB();
                fixtureA.getAABB().getCenterToOut(this.cA);
                fixtureB.getAABB().getCenterToOut(this.cB);
                this.m_debugDraw.drawSegment(this.cA, this.cB, this.color);
            }
        }
        if ((flags & 4) == 4) {
            this.color.set(0.9f, 0.3f, 0.9f);
            for (b = this.m_bodyList; b != null; b = b.getNext()) {
                if (!b.isActive()) continue;
                for (f = b.getFixtureList(); f != null; f = f.getNext()) {
                    AABB aabb = f.m_proxy.aabb;
                    Vec2[] vs = this.avs.get(4);
                    vs[0].set(aabb.lowerBound.x, aabb.lowerBound.y);
                    vs[1].set(aabb.upperBound.x, aabb.lowerBound.y);
                    vs[2].set(aabb.upperBound.x, aabb.upperBound.y);
                    vs[3].set(aabb.lowerBound.x, aabb.upperBound.y);
                    this.m_debugDraw.drawPolygon(vs, 4, this.color);
                }
            }
        }
        if ((flags & 0x10) == 16) {
            for (b = this.m_bodyList; b != null; b = b.getNext()) {
                this.xf.set(b.getTransform());
                this.xf.position.set(b.getWorldCenter());
                this.m_debugDraw.drawTransform(this.xf);
            }
        }
        if ((flags & 0x20) == 32) {
            this.m_contactManager.m_broadPhase.drawTree(this.m_debugDraw);
        }
    }

    public void queryAABB(QueryCallback callback, AABB aabb) {
        this.wqwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wqwrapper.callback = callback;
        this.m_contactManager.m_broadPhase.query(this.wqwrapper, aabb);
    }

    public void raycast(RayCastCallback callback, Vec2 point1, Vec2 point2) {
        this.wrcwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wrcwrapper.callback = callback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(point1);
        this.input.p2.set(point2);
        this.m_contactManager.m_broadPhase.raycast(this.wrcwrapper, this.input);
    }

    public Body getBodyList() {
        return this.m_bodyList;
    }

    public Joint getJointList() {
        return this.m_jointList;
    }

    public Contact getContactList() {
        return this.m_contactManager.m_contactList;
    }

    public void setWarmStarting(boolean flag) {
        this.m_warmStarting = flag;
    }

    public boolean isWarmStarting() {
        return this.m_warmStarting;
    }

    public void setContinuousPhysics(boolean flag) {
        this.m_continuousPhysics = flag;
    }

    public boolean isContinuousPhysics() {
        return this.m_continuousPhysics;
    }

    public int getProxyCount() {
        return this.m_contactManager.m_broadPhase.getProxyCount();
    }

    public int getBodyCount() {
        return this.m_bodyCount;
    }

    public int getJointCount() {
        return this.m_jointCount;
    }

    public int getContactCount() {
        return this.m_contactManager.m_contactCount;
    }

    public void setGravity(Vec2 gravity) {
        this.m_gravity.set(gravity);
    }

    public Vec2 getGravity() {
        return this.m_gravity;
    }

    public boolean isLocked() {
        return (this.m_flags & 2) == 2;
    }

    public void setAutoClearForces(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public boolean getAutoClearForces() {
        return (this.m_flags & 4) == 4;
    }

    private void solve(TimeStep step) {
        this.island.init(this.m_bodyCount, this.m_contactManager.m_contactCount, this.m_jointCount, this.m_contactManager.m_contactListener);
        Body b = this.m_bodyList;
        while (b != null) {
            b.m_flags &= 0xFFFFFFFE;
            b = b.m_next;
        }
        Contact c = this.m_contactManager.m_contactList;
        while (c != null) {
            c.m_flags &= 0xFFFFFFFE;
            c = c.m_next;
        }
        Joint j = this.m_jointList;
        while (j != null) {
            j.m_islandFlag = false;
            j = j.m_next;
        }
        int stackSize = this.m_bodyCount;
        if (this.stack.length < stackSize) {
            this.stack = new Body[stackSize];
        }
        Body seed = this.m_bodyList;
        while (seed != null) {
            if ((seed.m_flags & 1) != 1 && seed.isAwake() && seed.isActive() && seed.getType() != BodyType.STATIC) {
                this.island.clear();
                int stackCount = 0;
                this.stack[stackCount++] = seed;
                seed.m_flags |= 1;
                while (stackCount > 0) {
                    Body b2 = this.stack[--stackCount];
                    assert (b2.isActive());
                    this.island.add(b2);
                    b2.setAwake(true);
                    if (b2.getType() == BodyType.STATIC) continue;
                    ContactEdge ce = b2.m_contactList;
                    while (ce != null) {
                        Contact contact = ce.contact;
                        if ((contact.m_flags & 1) != 1 && contact.isEnabled() && contact.isTouching()) {
                            boolean sensorA = contact.m_fixtureA.m_isSensor;
                            boolean sensorB = contact.m_fixtureB.m_isSensor;
                            if (!sensorA && !sensorB) {
                                this.island.add(contact);
                                contact.m_flags |= 1;
                                Body other = ce.other;
                                if ((other.m_flags & 1) != 1) {
                                    assert (stackCount < stackSize);
                                    this.stack[stackCount++] = other;
                                    other.m_flags |= 1;
                                }
                            }
                        }
                        ce = ce.next;
                    }
                    JointEdge je = b2.m_jointList;
                    while (je != null) {
                        Body other;
                        if (!je.joint.m_islandFlag && (other = je.other).isActive()) {
                            this.island.add(je.joint);
                            je.joint.m_islandFlag = true;
                            if ((other.m_flags & 1) != 1) {
                                assert (stackCount < stackSize);
                                this.stack[stackCount++] = other;
                                other.m_flags |= 1;
                            }
                        }
                        je = je.next;
                    }
                }
                this.island.solve(step, this.m_gravity, this.m_allowSleep);
                for (int i = 0; i < this.island.m_bodyCount; ++i) {
                    Body b3 = this.island.m_bodies[i];
                    if (b3.getType() != BodyType.STATIC) continue;
                    b3.m_flags &= 0xFFFFFFFE;
                }
            }
            seed = seed.m_next;
        }
        for (Body b4 = this.m_bodyList; b4 != null; b4 = b4.getNext()) {
            if ((b4.m_flags & 1) == 0 || b4.getType() == BodyType.STATIC) continue;
            b4.synchronizeFixtures();
        }
        this.m_contactManager.findNewContacts();
    }

    private void solveTOI() {
        Contact c = this.m_contactManager.m_contactList;
        while (c != null) {
            c.m_flags |= 4;
            c.m_toiCount = 0.0f;
            c = c.m_next;
        }
        Body body = this.m_bodyList;
        while (body != null) {
            body.m_flags = (body.m_flags & 1) == 0 || body.getType() == BodyType.KINEMATIC || body.getType() == BodyType.STATIC ? (body.m_flags |= 0x40) : (body.m_flags &= 0xFFFFFFBF);
            body = body.m_next;
        }
        body = this.m_bodyList;
        while (body != null) {
            if ((body.m_flags & 0x40) != 64 && !body.isBullet()) {
                this.solveTOI(body);
                body.m_flags |= 0x40;
            }
            body = body.m_next;
        }
        body = this.m_bodyList;
        while (body != null) {
            if ((body.m_flags & 0x40) != 64 && body.isBullet()) {
                this.solveTOI(body);
                body.m_flags |= 0x40;
            }
            body = body.m_next;
        }
    }

    private void solveTOI(Body body) {
        boolean contactsOkay;
        Fixture fixtureB;
        Fixture fixtureA;
        Contact contact;
        BodyType type;
        Body other;
        ContactEdge ce;
        int count;
        boolean found;
        Contact toiContact = null;
        float toi = 1.0f;
        Body toiOther = null;
        int iter = 0;
        boolean bullet = body.isBullet();
        do {
            count = 0;
            found = false;
            ce = body.m_contactList;
            while (ce != null) {
                if (ce.contact != toiContact) {
                    other = ce.other;
                    type = other.getType();
                    if (!(!bullet ? type == BodyType.DYNAMIC : (other.m_flags & 0x40) == 0 || type != BodyType.STATIC && (ce.contact.m_flags & 0x10) != 0)) {
                        contact = ce.contact;
                        if (contact.isEnabled() && !(contact.m_toiCount > 10.0f)) {
                            fixtureA = contact.m_fixtureA;
                            fixtureB = contact.m_fixtureB;
                            if (!fixtureA.isSensor() && !fixtureB.isSensor()) {
                                Body bodyA = fixtureA.m_body;
                                Body bodyB = fixtureB.m_body;
                                this.toiInput.proxyA.set(fixtureA.getShape());
                                this.toiInput.proxyB.set(fixtureB.getShape());
                                this.toiInput.sweepA.set(bodyA.m_sweep);
                                this.toiInput.sweepB.set(bodyB.m_sweep);
                                this.toiInput.tMax = toi;
                                this.pool.getTimeOfImpact().timeOfImpact(this.toiOutput, this.toiInput);
                                if (this.toiOutput.state == TimeOfImpact.TOIOutputState.TOUCHING && this.toiOutput.t < toi) {
                                    toiContact = contact;
                                    toi = this.toiOutput.t;
                                    toiOther = other;
                                    found = true;
                                }
                                ++count;
                            }
                        }
                    }
                }
                ce = ce.next;
            }
        } while (found && count > 1 && ++iter < 50);
        if (toiContact == null) {
            body.advance(1.0f);
            return;
        }
        this.backup.set(body.m_sweep);
        body.advance(toi);
        toiContact.update(this.m_contactManager.m_contactListener);
        if (!toiContact.isEnabled()) {
            body.m_sweep.set(this.backup);
            this.solveTOI(body);
        }
        toiContact.m_toiCount += 1.0f;
        if (this.m_contacts == null || this.m_contacts.length < Settings.maxTOIContacts) {
            this.m_contacts = new Contact[Settings.maxTOIContacts];
        }
        count = 0;
        ce = body.m_contactList;
        while (ce != null && count < Settings.maxTOIContacts) {
            other = ce.other;
            type = other.getType();
            if (type != BodyType.DYNAMIC && (contact = ce.contact).isEnabled()) {
                fixtureA = contact.m_fixtureA;
                fixtureB = contact.m_fixtureB;
                if (!fixtureA.isSensor() && !fixtureB.isSensor()) {
                    if (contact != toiContact) {
                        contact.update(this.m_contactManager.m_contactListener);
                    }
                    if (contact.isEnabled() && contact.isTouching()) {
                        this.m_contacts[count] = contact;
                        ++count;
                    }
                }
            }
            ce = ce.next;
        }
        this.toiSolver.initialize(this.m_contacts, count, body);
        float k_toiBaumgarte = 0.75f;
        for (int i = 0; i < 20 && !(contactsOkay = this.toiSolver.solve(k_toiBaumgarte)); ++i) {
        }
        if (toiOther.getType() != BodyType.STATIC) {
            toiContact.m_flags |= 0x10;
        }
    }

    private void drawJoint(Joint joint) {
        Body bodyA = joint.getBodyA();
        Body bodyB = joint.getBodyB();
        Transform xf1 = bodyA.getTransform();
        Transform xf2 = bodyB.getTransform();
        Vec2 x1 = xf1.position;
        Vec2 x2 = xf2.position;
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        joint.getAnchorA(p1);
        joint.getAnchorB(p2);
        this.color.set(0.5f, 0.8f, 0.8f);
        switch (joint.getType()) {
            case DISTANCE: {
                this.m_debugDraw.drawSegment(p1, p2, this.color);
                break;
            }
            case PULLEY: {
                PulleyJoint pulley = (PulleyJoint)joint;
                Vec2 s1 = pulley.getGroundAnchorA();
                Vec2 s2 = pulley.getGroundAnchorB();
                this.m_debugDraw.drawSegment(s1, p1, this.color);
                this.m_debugDraw.drawSegment(s2, p2, this.color);
                this.m_debugDraw.drawSegment(s1, s2, this.color);
                break;
            }
            case CONSTANT_VOLUME: 
            case MOUSE: {
                break;
            }
            default: {
                this.m_debugDraw.drawSegment(x1, p1, this.color);
                this.m_debugDraw.drawSegment(p1, p2, this.color);
                this.m_debugDraw.drawSegment(x2, p2, this.color);
            }
        }
        this.pool.pushVec2(2);
    }

    private void drawShape(Fixture fixture, Transform xf, Color3f color) {
        switch (fixture.getType()) {
            case CIRCLE: {
                CircleShape circle = (CircleShape)fixture.getShape();
                Transform.mulToOut(xf, circle.m_p, this.center);
                float radius = circle.m_radius;
                this.axis.set(xf.R.col1);
                if (fixture.getUserData() != null && fixture.getUserData().equals(LIQUID_INT)) {
                    Body b = fixture.getBody();
                    this.liquidOffset.set(b.m_linearVelocity);
                    float linVelLength = b.m_linearVelocity.length();
                    this.averageLinearVel = this.averageLinearVel == -1.0f ? linVelLength : 0.98f * this.averageLinearVel + 0.02f * linVelLength;
                    this.liquidOffset.mulLocal(this.liquidLength / this.averageLinearVel / 2.0f);
                    this.circCenterMoved.set(this.center).addLocal(this.liquidOffset);
                    this.center.subLocal(this.liquidOffset);
                    this.m_debugDraw.drawSegment(this.center, this.circCenterMoved, this.liquidColor);
                    return;
                }
                this.m_debugDraw.drawSolidCircle(this.center, radius, this.axis, color);
                break;
            }
            case POLYGON: {
                PolygonShape poly = (PolygonShape)fixture.getShape();
                int vertexCount = poly.m_vertexCount;
                assert (vertexCount <= Settings.maxPolygonVertices);
                Vec2[] vertices = this.tlvertices.get(Settings.maxPolygonVertices);
                for (int i = 0; i < vertexCount; ++i) {
                    Transform.mulToOut(xf, poly.m_vertices[i], vertices[i]);
                }
                this.m_debugDraw.drawSolidPolygon(vertices, vertexCount, color);
            }
        }
    }
}

