/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.pooling.IWorldPool;

public class RevoluteJoint
extends Joint {
    public final Vec2 m_localAnchor1 = new Vec2();
    public final Vec2 m_localAnchor2 = new Vec2();
    public final Vec3 m_impulse = new Vec3();
    public float m_motorImpulse;
    public final Mat33 m_mass = new Mat33();
    public float m_motorMass;
    public boolean m_enableMotor;
    public float m_maxMotorTorque;
    public float m_motorSpeed;
    public boolean m_enableLimit;
    public float m_referenceAngle;
    public float m_lowerAngle;
    public float m_upperAngle;
    public LimitState m_limitState;

    public RevoluteJoint(IWorldPool argWorld, RevoluteJointDef def) {
        super(argWorld, def);
        this.m_localAnchor1.set(def.localAnchorA);
        this.m_localAnchor2.set(def.localAnchorB);
        this.m_referenceAngle = def.referenceAngle;
        this.m_motorImpulse = 0.0f;
        this.m_lowerAngle = def.lowerAngle;
        this.m_upperAngle = def.upperAngle;
        this.m_maxMotorTorque = def.maxMotorTorque;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableLimit = def.enableLimit;
        this.m_enableMotor = def.enableMotor;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        if (this.m_enableMotor || this.m_enableLimit) assert (b1.m_invI > 0.0f || b2.m_invI > 0.0f);
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
        r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
        Mat22.mulToOut(b1.getTransform().R, r1, r1);
        Mat22.mulToOut(b2.getTransform().R, r2, r2);
        float m1 = b1.m_invMass;
        float m2 = b2.m_invMass;
        float i1 = b1.m_invI;
        float i2 = b2.m_invI;
        this.m_mass.col1.x = m1 + m2 + r1.y * r1.y * i1 + r2.y * r2.y * i2;
        this.m_mass.col2.x = -r1.y * r1.x * i1 - r2.y * r2.x * i2;
        this.m_mass.col3.x = -r1.y * i1 - r2.y * i2;
        this.m_mass.col1.y = this.m_mass.col2.x;
        this.m_mass.col2.y = m1 + m2 + r1.x * r1.x * i1 + r2.x * r2.x * i2;
        this.m_mass.col3.y = r1.x * i1 + r2.x * i2;
        this.m_mass.col1.z = this.m_mass.col3.x;
        this.m_mass.col2.z = this.m_mass.col3.y;
        this.m_mass.col3.z = i1 + i2;
        this.m_motorMass = i1 + i2;
        if (this.m_motorMass > 0.0f) {
            this.m_motorMass = 1.0f / this.m_motorMass;
        }
        if (!this.m_enableMotor) {
            this.m_motorImpulse = 0.0f;
        }
        if (this.m_enableLimit) {
            float jointAngle = b2.m_sweep.a - b1.m_sweep.a - this.m_referenceAngle;
            if (MathUtils.abs(this.m_upperAngle - this.m_lowerAngle) < 2.0f * Settings.angularSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (jointAngle <= this.m_lowerAngle) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_impulse.z = 0.0f;
                }
                this.m_limitState = LimitState.AT_LOWER;
            } else if (jointAngle >= this.m_upperAngle) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_impulse.z = 0.0f;
                }
                this.m_limitState = LimitState.AT_UPPER;
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.z = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
        }
        if (step.warmStarting) {
            this.m_impulse.mulLocal(step.dtRatio);
            this.m_motorImpulse *= step.dtRatio;
            Vec2 temp = this.pool.popVec2();
            Vec2 P = this.pool.popVec2();
            P.set(this.m_impulse.x, this.m_impulse.y);
            temp.set(P).mulLocal(m1);
            b1.m_linearVelocity.subLocal(temp);
            b1.m_angularVelocity -= i1 * (Vec2.cross(r1, P) + this.m_motorImpulse + this.m_impulse.z);
            temp.set(P).mulLocal(m2);
            b2.m_linearVelocity.addLocal(temp);
            b2.m_angularVelocity += i2 * (Vec2.cross(r2, P) + this.m_motorImpulse + this.m_impulse.z);
            this.pool.pushVec2(2);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        this.pool.pushVec2(2);
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 v1 = b1.m_linearVelocity;
        float w1 = b1.m_angularVelocity;
        Vec2 v2 = b2.m_linearVelocity;
        float w2 = b2.m_angularVelocity;
        float m1 = b1.m_invMass;
        float m2 = b2.m_invMass;
        float i1 = b1.m_invI;
        float i2 = b2.m_invI;
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL) {
            float Cdot = w2 - w1 - this.m_motorSpeed;
            float impulse = this.m_motorMass * -Cdot;
            float oldImpulse = this.m_motorImpulse;
            float maxImpulse = step.dt * this.m_maxMotorTorque;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.m_motorImpulse - oldImpulse;
            w1 -= i1 * impulse;
            w2 += i2 * impulse;
        }
        Vec2 temp = this.pool.popVec2();
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            float newImpulse;
            r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
            r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
            Mat22.mulToOut(b1.getTransform().R, r1, r1);
            Mat22.mulToOut(b2.getTransform().R, r2, r2);
            Vec2 Cdot1 = this.pool.popVec2();
            Vec3 Cdot = this.pool.popVec3();
            Vec2.crossToOut(w1, r1, temp);
            Vec2.crossToOut(w2, r2, Cdot1);
            Cdot1.addLocal(v2).subLocal(v1).subLocal(temp);
            float Cdot2 = w2 - w1;
            Cdot.set(Cdot1.x, Cdot1.y, Cdot2);
            Vec3 impulse = this.pool.popVec3();
            this.m_mass.solve33ToOut(Cdot.negateLocal(), impulse);
            if (this.m_limitState == LimitState.EQUAL) {
                this.m_impulse.addLocal(impulse);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                newImpulse = this.m_impulse.z + impulse.z;
                if (newImpulse < 0.0f) {
                    this.m_mass.solve22ToOut(Cdot1.negateLocal(), temp);
                    impulse.x = temp.x;
                    impulse.y = temp.y;
                    impulse.z = -this.m_impulse.z;
                    this.m_impulse.x += temp.x;
                    this.m_impulse.y += temp.y;
                    this.m_impulse.z = 0.0f;
                }
            } else if (this.m_limitState == LimitState.AT_UPPER && (newImpulse = this.m_impulse.z + impulse.z) > 0.0f) {
                this.m_mass.solve22ToOut(Cdot1.negateLocal(), temp);
                impulse.x = temp.x;
                impulse.y = temp.y;
                impulse.z = -this.m_impulse.z;
                this.m_impulse.x += temp.x;
                this.m_impulse.y += temp.y;
                this.m_impulse.z = 0.0f;
            }
            Vec2 P = this.pool.popVec2();
            P.set(impulse.x, impulse.y);
            temp.set(P).mulLocal(m1);
            v1.subLocal(temp);
            w1 -= i1 * (Vec2.cross(r1, P) + impulse.z);
            temp.set(P).mulLocal(m2);
            v2.addLocal(temp);
            w2 += i2 * (Vec2.cross(r2, P) + impulse.z);
            this.pool.pushVec2(2);
            this.pool.pushVec3(2);
        } else {
            r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
            r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
            Mat22.mulToOut(b1.getTransform().R, r1, r1);
            Mat22.mulToOut(b2.getTransform().R, r2, r2);
            Vec2 Cdot = this.pool.popVec2();
            Vec2 impulse = this.pool.popVec2();
            Vec2.crossToOut(w1, r1, temp);
            Vec2.crossToOut(w2, r2, Cdot);
            Cdot.addLocal(v2).subLocal(v1).subLocal(temp);
            this.m_mass.solve22ToOut(Cdot.negateLocal(), impulse);
            this.m_impulse.x += impulse.x;
            this.m_impulse.y += impulse.y;
            temp.set(impulse).mulLocal(m1);
            v1.subLocal(temp);
            w1 -= i1 * Vec2.cross(r1, impulse);
            temp.set(impulse).mulLocal(m2);
            v2.addLocal(temp);
            w2 += i2 * Vec2.cross(r2, impulse);
            this.pool.pushVec2(2);
        }
        b1.m_angularVelocity = w1;
        b2.m_angularVelocity = w2;
        this.pool.pushVec2(3);
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        float angularError = 0.0f;
        float positionError = 0.0f;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            float C;
            float angle = b2.m_sweep.a - b1.m_sweep.a - this.m_referenceAngle;
            float limitImpulse = 0.0f;
            if (this.m_limitState == LimitState.EQUAL) {
                C = MathUtils.clamp(angle - this.m_lowerAngle, -Settings.maxAngularCorrection, Settings.maxAngularCorrection);
                limitImpulse = -this.m_motorMass * C;
                angularError = MathUtils.abs(C);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                C = angle - this.m_lowerAngle;
                angularError = -C;
                C = MathUtils.clamp(C + Settings.angularSlop, -Settings.maxAngularCorrection, 0.0f);
                limitImpulse = -this.m_motorMass * C;
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                angularError = C = angle - this.m_upperAngle;
                C = MathUtils.clamp(C - Settings.angularSlop, 0.0f, Settings.maxAngularCorrection);
                limitImpulse = -this.m_motorMass * C;
            }
            b1.m_sweep.a -= b1.m_invI * limitImpulse;
            b2.m_sweep.a += b2.m_invI * limitImpulse;
            b1.synchronizeTransform();
            b2.synchronizeTransform();
        }
        Vec2 impulse = this.pool.popVec2();
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        Vec2 C = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
        r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
        Mat22.mulToOut(b1.getTransform().R, r1, r1);
        Mat22.mulToOut(b2.getTransform().R, r2, r2);
        C.set(b2.m_sweep.c).addLocal(r2).subLocal(b1.m_sweep.c).subLocal(r1);
        positionError = C.length();
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        float k_allowedStretch = 10.0f * Settings.linearSlop;
        if (C.lengthSquared() > k_allowedStretch * k_allowedStretch) {
            Vec2 u = this.pool.popVec2();
            float m = invMass1 + invMass2;
            if (m > 0.0f) {
                m = 1.0f / m;
            }
            impulse.set(C).negateLocal().mulLocal(m);
            float k_beta = 0.5f;
            u.set(impulse).mulLocal(0.5f * invMass1);
            b1.m_sweep.c.subLocal(u);
            u.set(impulse).mulLocal(0.5f * invMass2);
            b2.m_sweep.c.addLocal(u);
            C.set(b2.m_sweep.c).addLocal(r2).subLocal(b1.m_sweep.c).subLocal(r1);
            this.pool.pushVec2(1);
        }
        Mat22 K1 = this.pool.popMat22();
        K1.col1.x = invMass1 + invMass2;
        K1.col2.x = 0.0f;
        K1.col1.y = 0.0f;
        K1.col2.y = invMass1 + invMass2;
        Mat22 K2 = this.pool.popMat22();
        K2.col1.x = invI1 * r1.y * r1.y;
        K2.col2.x = -invI1 * r1.x * r1.y;
        K2.col1.y = -invI1 * r1.x * r1.y;
        K2.col2.y = invI1 * r1.x * r1.x;
        Mat22 K3 = this.pool.popMat22();
        K3.col1.x = invI2 * r2.y * r2.y;
        K3.col2.x = -invI2 * r2.x * r2.y;
        K3.col1.y = -invI2 * r2.x * r2.y;
        K3.col2.y = invI2 * r2.x * r2.x;
        K1.addLocal(K2).addLocal(K3);
        K1.solveToOut(C.negateLocal(), impulse);
        C.set(impulse).mulLocal(b1.m_invMass);
        b1.m_sweep.c.subLocal(C);
        b1.m_sweep.a -= b1.m_invI * Vec2.cross(r1, impulse);
        C.set(impulse).mulLocal(b2.m_invMass);
        b2.m_sweep.c.addLocal(C);
        b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, impulse);
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        this.pool.pushMat22(3);
        this.pool.pushVec2(4);
        return positionError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, argOut);
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
        argOut.set(this.m_impulse.x, this.m_impulse.y).mulLocal(inv_dt);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return inv_dt * this.m_impulse.z;
    }

    public float getJointAngle() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        return b2.m_sweep.a - b1.m_sweep.a - this.m_referenceAngle;
    }

    public float getJointSpeed() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        return b2.m_angularVelocity - b1.m_angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = flag;
    }

    public float getMotorTorque() {
        return this.m_motorImpulse;
    }

    public void setMotorSpeed(float speed) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = speed;
    }

    public void setMaxMotorTorque(float torque) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorTorque = torque;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableLimit = flag;
    }

    public float getLowerLimit() {
        return this.m_lowerAngle;
    }

    public float getUpperLimit() {
        return this.m_upperAngle;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_lowerAngle = lower;
        this.m_upperAngle = upper;
    }
}

