package triangle;
import interfaces.IPrototype;
import interfaces.Brush;

public class Triangle implements IPrototype
{
    public Triangle()
    {
        this.centerX = 0;
        this.centerY = 0;
        this.size = 10;
        this.brush = new Brush(1,1);
    }
    public Triangle(double centerX, double centerY, double size)
    {
        this.centerX = centerX;
        this.centerY = centerY;
        this.size = size;
    }
    public void setBrush(Brush brush)
    {
        this.brush = brush;
    }
    // Clone deep copy implementation
    public IPrototype clone()
    {
	System.out.println("Cloning a new triangle(" + centerX + "," + centerY + "," + size +")");
        Triangle clone = new Triangle(centerX, centerY, size);
	clone.setBrush(new Brush(brush));
	return clone;
    }
    private double centerX;
    private double centerY;
    private double size;
    private Brush brush;
}
