import interfaces.IPrototype;
import java.util.Scanner;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

class Main
{
    public static void main (String args[]) throws Exception
    {
    int op;
    PrototypeManager manager = new PrototypeManager();
    do
    {
      File currentDir = new File("./plugins");
      String []plugins = currentDir.list();
      int i;
      URL[] jars = new URL[plugins.length];
      for (i = 0; i < plugins.length; i++)
      {
        System.out.println(i+1 + " - " + plugins[i].split("\\.")[0]);
        jars[i] = (new File("./plugins/" + plugins[i])).toURL();
      }
      URLClassLoader ulc = new URLClassLoader(jars);
      for (i = 0; i < plugins.length; i++)
      {
        String prototypeName = plugins[i].split("\\.")[0];
        IPrototype prototype = (IPrototype) Class.forName(prototypeName.toLowerCase() + "." + prototypeName, true, ulc).newInstance();
        manager.addPrototype(prototypeName, prototype);
      }
      System.out.println(i+1 + " - Plugin refresh");
      System.out.println("Escolha sua opção ou 0 para sair: ");
      Scanner sc = new Scanner(System.in);
      op = sc.nextInt();
      if (op != 0 && op != i+1)
      {
           Editor editor = new Editor(manager.lookup(plugins[op-1].split("\\.")[0]));
	   editor.setScene();
      }
    } while (op != 0);
    }
}
