public class ContaEspecial extends Conta{
    private double limite;
    
    public ContaEspecial(long numero, double saldo, double limite){
        super(numero, saldo);
        this.setLimite(limite);
    }    
    
    public ContaEspecial(long numero, double limite){
        this(numero, 0, limite);
    } 
    
    
    public void setLimite(double limite){
        this.limite = limite;
    }    
    
    public double getLimite(){
        return this.limite;
    }   
    
    public void sacar(double valor){
        if(valor <= this.getSaldo() + this.getLimite())
            this.setSaldo(this.getSaldo() - valor);
    } 
    
 
    
    public String toString(){
        return super.toString() + " - Limite: RS" + this.getLimite();
    }    
}
