public class Conta implements Ordenavel{
    private long numero;
    private double saldo;
    
    public Conta(long numero, double saldo){
        this.setNumero(numero);
        this.setSaldo(saldo);
    }    
    
    public Conta(long numero){
        this(numero, 0);
    }    
    
    public void setNumero(long numero){
        this.numero = numero;
    }    
    
    public long getNumero(){
        return this.numero;
    }     

    public void setSaldo(double saldo){
        this.saldo = saldo;
    }    
    
    public double getSaldo(){
        return this.saldo;
    } 
    
    public void depositar(double valor){
        this.setSaldo(this.getSaldo() + valor);
    }  
    
    
    public void sacar(double valor){
        if(valor >= this.getSaldo() )
            this.setSaldo(this.getSaldo() - valor);
    }  

    public boolean equals(Conta conta){
        return this.getNumero() == conta.getNumero();
    }  
    
    public String toString(){
        return "[no. " + this.getNumero() + "] - RS " + this.getSaldo();
    }    
    
    public long compare(Ordenavel o){
        return this.getNumero() - ((Conta)o).getNumero(); 
    }    
    
    
}
