package br.edu.ifba.inf008.avaliacao.modelo;

import java.util.HashSet;
import java.util.Set;

public abstract class Atividade implements Comparable<Atividade>{

	private long id;
	private String descricao;
	protected Set<Atividade> pre;
	protected Set<Atividade> pos;	
	
	
	public Atividade(long id,  String descricao){
		this.setId(id);
		this.setDescricao(descricao);
		this.pre = new HashSet<Atividade>();
		this.pos = new HashSet<Atividade>();		
		
	}
	
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public String getDescricao() {
		return descricao;
	}
	public void setDescricao(String descricao) {
		this.descricao = descricao;
	}
	
	public abstract boolean estaConcluida();
	
	public abstract long getDuracao();
	
	public void addAtividadePre(Atividade atividade){
		this.pre.add(atividade);
	}	
	
	public void addAtividadePos(Atividade atividade){
		this.pos.add(atividade);
	}
	
	public long startAfter(){
		long after = 0;
		for(Atividade atividade : this.pre){
			long tempo = atividade.getDuracao() + atividade.startAfter();
			if(after < tempo)
				after = tempo;
		}
		return after;
	}	
	
	public int compareTo(Atividade atividade){
		return (int)(this.getId() - atividade.getId());
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (id ^ (id >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Atividade other = (Atividade) obj;
		if (id != other.id)
			return false;
		return true;
	}
	

}
