package br.edu.ifba.inf008.avaliacao.teste;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import br.edu.ifba.inf008.avaliacao.modelo.Atividade;
import br.edu.ifba.inf008.avaliacao.modelo.ComparaPessoaPeloNome;
import br.edu.ifba.inf008.avaliacao.modelo.Elementar;
import br.edu.ifba.inf008.avaliacao.modelo.Macro;
import br.edu.ifba.inf008.avaliacao.modelo.Pessoa;
import br.edu.ifba.inf008.avaliacao.modelo.Projeto;
import br.edu.ifba008.avaliacao.excecao.AtividadeInexistenteException;

public class TesteProjeto {
	
	
	public void run2(){

		Projeto projeto = new Projeto("Avaliacao II");
		
		Elementar a = new Elementar(10, "A", 3);
		Elementar b = new Elementar(20, "B", 5);
		Elementar c = new Elementar(30, "C", 2);
		Elementar d = new Elementar(40, "D", 1);
		Elementar e = new Elementar(50, "E", 6);
		Elementar f = new Elementar(60, "F", 1);
		Elementar g = new Elementar(70, "G", 2);
		Elementar h = new Elementar(80, "H", 4);
		Elementar i = new Elementar(90, "I", 2);

		a.addAtividadePos(b);
		a.addAtividadePos(c);
		
		b.addAtividadePre(a);
		b.addAtividadePos(d);

		c.addAtividadePre(a);
		c.addAtividadePos(d);
		
		d.addAtividadePre(b);
		d.addAtividadePre(c);		
		d.addAtividadePos(e);
		d.addAtividadePos(f);
		
		e.addAtividadePre(d);
		e.addAtividadePos(g);
		e.addAtividadePos(h);
		
		f.addAtividadePre(d);
		f.addAtividadePos(h);
		
		g.addAtividadePre(e);
		g.addAtividadePos(i);

		h.addAtividadePre(e);
		h.addAtividadePre(f);
		h.addAtividadePos(i);
		
		i.addAtividadePre(g);
		i.addAtividadePre(h);
		
		
		projeto.addAtividade(a);
		projeto.addAtividade(b);
		projeto.addAtividade(c);
		projeto.addAtividade(d);
		projeto.addAtividade(e);
		projeto.addAtividade(f);
		projeto.addAtividade(g);
		projeto.addAtividade(h);
		projeto.addAtividade(i);
		
		for(int j = 10; j <= 150; j+=10){
			try{
				Atividade atividade = projeto.findById(j);
				long inicio = projeto.startAfter(atividade.getId());
				System.out.println(atividade.getDescricao() + " pode começar apos " + inicio);
			}catch(AtividadeInexistenteException minhaExcecao){
				System.out.println("O Atividade informada inexiste no projeto em questao: Cod da Atividade - " + minhaExcecao.getIdAtividade());
			}	
		}

		
	}
	
	public void run3(){
		Projeto projeto = new Projeto("Avaliacao II");
		
		Macro a = new Macro(100, "A");
		Elementar a11 = new Elementar(111, "A11", 3);
		Elementar a12 = new Elementar(112, "A12", 4);
		Elementar a21 = new Elementar(121, "A21", 10);
		Elementar a22 = new Elementar(122, "A22", 6);
		
		a11.addAtividadePos(a21);
		a11.addAtividadePos(a22);
		a12.addAtividadePos(a21);
		a12.addAtividadePos(a22);
		a21.addAtividadePre(a11);
		a21.addAtividadePre(a12);		
		a22.addAtividadePre(a11);
		a22.addAtividadePre(a12);
		
		
		
		
		a.addAtividadeInterna(a11);
		a.addAtividadeInterna(a12);
		a.addAtividadeInterna(a21);
		a.addAtividadeInterna(a22);
		
		
		Elementar b = new Elementar(200, "B", 5);


		
		a.addAtividadePos(b);
		b.addAtividadePre(a);
		
		projeto.addAtividade(a);
		projeto.addAtividade(b);
		

		try{
			Atividade atividade = projeto.findById(200);
			long inicio = projeto.startAfter(atividade.getId());
			System.out.println(atividade.getDescricao() + " pode começar apos " + inicio);
		}catch(AtividadeInexistenteException minhaExcecao){
			System.out.println("A atividade informada inexiste no projeto em questao: Cod da Atividade - " + minhaExcecao.getIdAtividade());
		}	
		
		
		
	}
	

	public void run4(){

		Projeto projeto = new Projeto("Avaliacao II");
		
		
		Pessoa p1 = new Pessoa("A1304", "ABC Pessoa 1");
		Pessoa p2 = new Pessoa("A1044", "PQR Pessoa 2");
		Pessoa p3 = new Pessoa("Z1304", "MNO Pessoa 3");
		Pessoa p4 = new Pessoa("F0327", "DEF Pessoa 4");
		
		
		Elementar a = new Elementar(10, "A", 3);
		Elementar b = new Elementar(20, "B", 5);
		Elementar c = new Elementar(30, "C", 2);
		Elementar d = new Elementar(40, "D", 1);
		Elementar e = new Elementar(50, "E", 6);
		Elementar f = new Elementar(60, "F", 1);
		Elementar g = new Elementar(70, "G", 2);
		Elementar h = new Elementar(80, "H", 4);
		Elementar i = new Elementar(90, "I", 2);

		a.addAtividadePos(b);
		a.addAtividadePos(c);
		
		b.addAtividadePre(a);
		b.addAtividadePos(d);

		c.addAtividadePre(a);
		c.addAtividadePos(d);
		
		d.addAtividadePre(b);
		d.addAtividadePre(c);		
		d.addAtividadePos(e);
		d.addAtividadePos(f);
		
		e.addAtividadePre(d);
		e.addAtividadePos(g);
		e.addAtividadePos(h);
		
		f.addAtividadePre(d);
		f.addAtividadePos(h);
		
		g.addAtividadePre(e);
		g.addAtividadePos(i);

		h.addAtividadePre(e);
		h.addAtividadePre(f);
		h.addAtividadePos(i);
		
		i.addAtividadePre(g);
		i.addAtividadePre(h);
		
		projeto.addAtividade(d);
		projeto.addAtividade(a);
		projeto.addAtividade(f);
		projeto.addAtividade(g);
		projeto.addAtividade(b);
		projeto.addAtividade(h);
		projeto.addAtividade(c);
		projeto.addAtividade(e);
		projeto.addAtividade(i);
		
		projeto.addResponsavel(p1);
		projeto.addResponsavel(p2);
		projeto.addResponsavel(p3);
		projeto.addResponsavel(p4);

		System.out.println("ATIVIDADES");
		
		
		
		for(Atividade atividade : projeto.getAtividades())
			System.out.println(atividade.getId());
		
		System.out.println("Ordenando...");
		for(Atividade atividade : projeto.getAtividades())
			System.out.println(atividade.getId());
		
		System.out.println("PESSOAS");
		
		
		for(Pessoa pessoa : projeto.getResponsaveis())
			System.out.println(pessoa.getMatricula() + " - " + pessoa.getNome());
		
		System.out.println("Ordenando...");
		
		List<Pessoa> pessoasList = new LinkedList<Pessoa>();
		pessoasList.addAll(projeto.getResponsaveis());
		
		Collections.sort(pessoasList);
		
		for(Pessoa pessoa : pessoasList)
			System.out.println(pessoa.getMatricula() + " - " + pessoa.getNome());

		System.out.println("Reordenando...");
		
		Collections.sort(pessoasList, new ComparaPessoaPeloNome());
		for(Pessoa pessoa : pessoasList)
			System.out.println(pessoa.getMatricula() + " - " + pessoa.getNome());
		
		
	}

	
	public void run1(){
		
		Projeto projeto = new Projeto("Avaliacao II");
		
		Macro a = new Macro(10, "A");
		Elementar a1 = new Elementar(11, "A1", 2);
		
		Elementar a2 = new Elementar(12, "A2", 2);

		
		Elementar b = new Elementar(20, "B", 5);
		

		a1.addAtividadePos(a2);
		a2.addAtividadePre(a1);
		
		
		a.addAtividadeInterna(a1);
		a.addAtividadeInterna(a2);
		
		
		a.addAtividadePos(b);
		b.addAtividadePre(a);

		projeto.addAtividade(a);
		projeto.addAtividade(b);		
		
		
		System.out.println("Projeto terminado: " + projeto.estaConcluido());
		a1.setConcluida(true);
		System.out.println("Projeto terminado: " + projeto.estaConcluido());
		a2.setConcluida(true);
		System.out.println("Projeto terminado: " + projeto.estaConcluido());
		b.setConcluida(true);
		System.out.println("Projeto terminado: " + projeto.estaConcluido());
		
	}
	
	
	public static void main(String[] args) throws AtividadeInexistenteException{
		TesteProjeto teste = new TesteProjeto();
		System.out.println("Teste 1...");
		teste.run1();
		System.out.println("");
		System.out.println("Teste 2...");
		teste.run2();
		System.out.println("");
		System.out.println("Teste 3...");
		teste.run3();
		System.out.println("");
		System.out.println("Teste 4...");
		teste.run4();
		System.out.println("");
	}

}
